/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;

public interface FileFormatFactory {
    public String identifier();

    public FileFormat create(FormatContext var1);

    public static class FormatContext {
        private final Options formatOptions;
        private final int readBatchSize;
        private final int zstdLevel;
        @Nullable
        private final MemorySize blockSize;

        @VisibleForTesting
        public FormatContext(Options formatOptions, int readBatchSize) {
            this(formatOptions, readBatchSize, 1, null);
        }

        public FormatContext(Options formatOptions, int readBatchSize, int zstdLevel, @Nullable MemorySize blockSize) {
            this.formatOptions = formatOptions;
            this.readBatchSize = readBatchSize;
            this.zstdLevel = zstdLevel;
            this.blockSize = blockSize;
        }

        public Options formatOptions() {
            return this.formatOptions;
        }

        public int readBatchSize() {
            return this.readBatchSize;
        }

        public int zstdLevel() {
            return this.zstdLevel;
        }

        @Nullable
        public MemorySize blockSize() {
            return this.blockSize;
        }
    }
}

