/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.compact.MultiAwareBucketTableScan;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.flink.source.operator.CombinedCompactorSourceFunction;
import org.apache.paimon.flink.source.operator.MultiTablesReadOperator;
import org.apache.paimon.flink.utils.JavaTypeInfo;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;

public class CombinedAwareStreamingSourceFunction
extends CombinedCompactorSourceFunction<Tuple2<Split, String>> {
    private final long monitorInterval;
    private transient MultiTableScanBase<Tuple2<Split, String>> tableScan;

    public CombinedAwareStreamingSourceFunction(Catalog.Loader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, long monitorInterval) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, true);
        this.monitorInterval = monitorInterval;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.tableScan = new MultiAwareBucketTableScan(this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.isStreaming, this.isRunning);
    }

    @Override
    void scanTable() throws Exception {
        while (this.isRunning.get()) {
            MultiTableScanBase.ScanResult scanResult = this.tableScan.scanTable((SourceFunction.SourceContext<Tuple2<Split, String>>)this.ctx);
            if (scanResult == MultiTableScanBase.ScanResult.FINISHED) {
                return;
            }
            if (scanResult != MultiTableScanBase.ScanResult.IS_EMPTY) continue;
            Thread.sleep(this.monitorInterval);
        }
    }

    public static DataStream<RowData> buildSource(StreamExecutionEnvironment env, String name, TypeInformation<RowData> typeInfo, Catalog.Loader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, long monitorInterval) {
        CombinedAwareStreamingSourceFunction function = new CombinedAwareStreamingSourceFunction(catalogLoader, includingPattern, excludingPattern, databasePattern, monitorInterval);
        StreamSource sourceOperator = new StreamSource((SourceFunction)function);
        boolean isParallel = false;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{new JavaTypeInfo<Split>(Split.class), BasicTypeInfo.STRING_TYPE_INFO});
        return new DataStreamSource(env, (TypeInformation)tupleTypeInfo, sourceOperator, isParallel, name, Boundedness.CONTINUOUS_UNBOUNDED).forceNonParallel().partitionCustom((Partitioner & Serializable)(key, numPartitions) -> key % numPartitions, (KeySelector & Serializable)split -> ((DataSplit)split.f0).bucket()).transform(name, typeInfo, (OneInputStreamOperator)new MultiTablesReadOperator(catalogLoader, true));
    }

    public void close() throws Exception {
        super.close();
        if (this.tableScan != null) {
            this.tableScan.close();
        }
    }
}

