/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import java.io.Serializable;
import java.time.Duration;
import java.util.regex.Pattern;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.compact.MultiAwareBucketTableScan;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.flink.source.operator.CombinedCompactorSourceFunction;
import org.apache.paimon.flink.source.operator.MultiTablesReadOperator;
import org.apache.paimon.flink.utils.JavaTypeInfo;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedAwareBatchSourceFunction
extends CombinedCompactorSourceFunction<Tuple2<Split, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinedAwareBatchSourceFunction.class);
    private MultiTableScanBase<Tuple2<Split, String>> tableScan;

    public CombinedAwareBatchSourceFunction(Catalog.Loader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, false);
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.tableScan = new MultiAwareBucketTableScan(this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.isStreaming, this.isRunning);
    }

    @Override
    void scanTable() throws Exception {
        if (this.isRunning.get()) {
            MultiTableScanBase.ScanResult scanResult = this.tableScan.scanTable((SourceFunction.SourceContext<Tuple2<Split, String>>)this.ctx);
            if (scanResult == MultiTableScanBase.ScanResult.FINISHED) {
                return;
            }
            if (scanResult == MultiTableScanBase.ScanResult.IS_EMPTY) {
                LOGGER.info("No file were collected for the table of aware-bucket");
            }
        }
    }

    public static DataStream<RowData> buildSource(StreamExecutionEnvironment env, String name, TypeInformation<RowData> typeInfo, Catalog.Loader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, Duration partitionIdleTime) {
        CombinedAwareBatchSourceFunction function = new CombinedAwareBatchSourceFunction(catalogLoader, includingPattern, excludingPattern, databasePattern);
        StreamSource sourceOperator = new StreamSource((SourceFunction)function);
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{new JavaTypeInfo<Split>(Split.class), BasicTypeInfo.STRING_TYPE_INFO});
        return new DataStreamSource(env, (TypeInformation)tupleTypeInfo, sourceOperator, false, name, Boundedness.BOUNDED).forceNonParallel().partitionCustom((Partitioner & Serializable)(key, numPartitions) -> key % numPartitions, (KeySelector & Serializable)split -> ((DataSplit)split.f0).bucket()).transform(name, typeInfo, (OneInputStreamOperator)new MultiTablesReadOperator(catalogLoader, false, partitionIdleTime));
    }

    public void close() throws Exception {
        super.close();
        if (this.tableScan != null) {
            this.tableScan.close();
        }
    }
}

