/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.SplitEnumeratorMetricGroup;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.metrics.FlinkMetricRegistry;
import org.apache.paimon.flink.source.ContinuousFileSplitEnumerator;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FlinkSource;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.StreamTableScan;

public class ContinuousFileStoreSource
extends FlinkSource {
    private static final long serialVersionUID = 4L;
    protected final Map<String, String> options;
    protected final BucketMode bucketMode;

    public ContinuousFileStoreSource(ReadBuilder readBuilder, Map<String, String> options, @Nullable Long limit) {
        this(readBuilder, options, limit, BucketMode.HASH_FIXED);
    }

    public ContinuousFileStoreSource(ReadBuilder readBuilder, Map<String, String> options, @Nullable Long limit, BucketMode bucketMode) {
        super(readBuilder, limit);
        this.options = options;
        this.bucketMode = bucketMode;
    }

    public Boundedness getBoundedness() {
        Long boundedWatermark = CoreOptions.fromMap(this.options).scanBoundedWatermark();
        return boundedWatermark != null ? Boundedness.BOUNDED : Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> restoreEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, PendingSplitsCheckpoint checkpoint) {
        Long nextSnapshotId = null;
        ArrayList<FileStoreSourceSplit> splits = new ArrayList();
        if (checkpoint != null) {
            nextSnapshotId = checkpoint.currentSnapshotId();
            splits = checkpoint.splits();
        }
        StreamTableScan scan = this.readBuilder.newStreamScan();
        if (this.metricGroup(context) != null) {
            ((StreamDataTableScan)scan).withMetricsRegistry(new FlinkMetricRegistry((MetricGroup)context.metricGroup()));
        }
        scan.restore(nextSnapshotId);
        return this.buildEnumerator(context, splits, nextSnapshotId, scan);
    }

    @Nullable
    private SplitEnumeratorMetricGroup metricGroup(SplitEnumeratorContext<?> context) {
        try {
            return context.metricGroup();
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    protected SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> buildEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, Collection<FileStoreSourceSplit> splits, @Nullable Long nextSnapshotId, StreamTableScan scan) {
        Options options = Options.fromMap(this.options);
        return new ContinuousFileSplitEnumerator(context, splits, nextSnapshotId, options.get(CoreOptions.CONTINUOUS_DISCOVERY_INTERVAL).toMillis(), scan, this.bucketMode, options.get(CoreOptions.SCAN_MAX_SPLITS_PER_TASK), options.get(FlinkConnectorOptions.STREAMING_READ_SHUFFLE_BUCKET_WITH_PARTITION));
    }
}

