/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class DynamicPartitionLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAX_PT = "max_pt()";
    private final Table table;
    private final Duration refreshInterval;
    private TableScan scan;
    private Comparator<InternalRow> comparator;
    private LocalDateTime lastRefresh;
    @Nullable
    private BinaryRow partition;

    private DynamicPartitionLoader(Table table, Duration refreshInterval) {
        this.table = table;
        this.refreshInterval = refreshInterval;
    }

    public void open() {
        this.scan = this.table.newReadBuilder().newScan();
        RowType partitionType = this.table.rowType().project(this.table.partitionKeys());
        this.comparator = CodeGenUtils.newRecordComparator(partitionType.getFieldTypes());
    }

    public void addPartitionKeysTo(List<String> joinKeys, List<String> projectFields) {
        List<String> partitionKeys = this.table.partitionKeys();
        Preconditions.checkArgument(joinKeys.stream().noneMatch(partitionKeys::contains));
        joinKeys.addAll(partitionKeys);
        partitionKeys.stream().filter(k -> !projectFields.contains(k)).forEach(projectFields::add);
    }

    @Nullable
    public BinaryRow partition() {
        return this.partition;
    }

    public boolean checkRefresh() {
        if (this.lastRefresh != null && !this.lastRefresh.plus(this.refreshInterval).isBefore(LocalDateTime.now())) {
            return false;
        }
        BinaryRow previous = this.partition;
        this.partition = this.scan.listPartitions().stream().max(this.comparator).orElse(null);
        this.lastRefresh = LocalDateTime.now();
        return !Objects.equals(previous, this.partition);
    }

    @Nullable
    public static DynamicPartitionLoader of(Table table) {
        Options options = Options.fromMap(table.options());
        String dynamicPartition = options.get(FlinkConnectorOptions.LOOKUP_DYNAMIC_PARTITION);
        if (dynamicPartition == null) {
            return null;
        }
        if (!dynamicPartition.equalsIgnoreCase(MAX_PT)) {
            throw new UnsupportedOperationException("Unsupported dynamic partition pattern: " + dynamicPartition);
        }
        Duration refresh = options.get(FlinkConnectorOptions.LOOKUP_DYNAMIC_PARTITION_REFRESH_INTERVAL);
        return new DynamicPartitionLoader(table, refresh);
    }
}

