/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.RepairAction;

public class RepairActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "repair";
    private static final String IDENTIFIER_KEY = "identifier";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String warehouse = params.get("warehouse");
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        String identifier = params.get(IDENTIFIER_KEY);
        RepairAction action = new RepairAction(warehouse, identifier, catalogConfig);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"repair\" synchronize information from the file system to Metastore.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  repair --warehouse <warehouse_path> [--identifier <database.table>] ");
        System.out.println();
        System.out.println("If --identifier is not provided, all databases and tables in the catalog will be synchronized.");
        System.out.println("If --identifier is a database name, all tables in that database will be synchronized.");
        System.out.println("If --identifier is a databaseName.tableName, only that specific table will be synchronized.");
        System.out.println("If --identifier is a string combine with format as databaseName.tableName or databaseName delimiter by ',', specific table and database will be synchronized.");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  repair --warehouse hdfs:///path/to/warehouse");
        System.out.println("  repair --warehouse hdfs:///path/to/warehouse --identifier test_db");
        System.out.println("  repair --warehouse hdfs:///path/to/warehouse --identifier test_db.T");
        System.out.println("  repair --warehouse hdfs:///path/to/warehouse --identifier test_db.T,test_db01,test_db.T1");
    }
}

