/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CreateTagFromTimestampAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class CreateTagFromTimestampActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "create_tag_from_timestamp";
    private static final String TABLE = "table";
    private static final String TAG = "tag";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIME_RETAINED = "time_retained";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String warehouse = params.get("warehouse");
        String table = params.get(TABLE);
        String tag = params.get(TAG);
        Long timestamp = Long.parseLong(params.get(TIMESTAMP));
        String timeRetained = params.get(TIME_RETAINED);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        CreateTagFromTimestampAction migrateFileAction = new CreateTagFromTimestampAction(warehouse, table, tag, timestamp, timeRetained, catalogConfig);
        return Optional.of(migrateFileAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"create_tag_from_timestamp\" create tag from timestamp.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  create_tag_from_timestamp --warehouse <warehouse_path> --table <database.table_name> --tag <tag> --timestamp <timestamp> [--timeRetained <duration>] [--options <key>=<value>,<key>=<value>,...]");
    }
}

