/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.utils.RoaringBitmap32;

public class BitmapDeletionVector
implements DeletionVector {
    public static final int MAGIC_NUMBER = 1581511376;
    private final RoaringBitmap32 roaringBitmap;

    public BitmapDeletionVector() {
        this.roaringBitmap = new RoaringBitmap32();
    }

    private BitmapDeletionVector(RoaringBitmap32 roaringBitmap) {
        this.roaringBitmap = roaringBitmap;
    }

    @Override
    public void delete(long position) {
        this.checkPosition(position);
        this.roaringBitmap.add((int)position);
    }

    @Override
    public void merge(DeletionVector deletionVector) {
        if (!(deletionVector instanceof BitmapDeletionVector)) {
            throw new RuntimeException("Only instance with the same class type can be merged.");
        }
        this.roaringBitmap.or(((BitmapDeletionVector)deletionVector).roaringBitmap);
    }

    @Override
    public boolean checkedDelete(long position) {
        this.checkPosition(position);
        return this.roaringBitmap.checkedAdd((int)position);
    }

    @Override
    public boolean isDeleted(long position) {
        this.checkPosition(position);
        return this.roaringBitmap.contains((int)position);
    }

    @Override
    public boolean isEmpty() {
        return this.roaringBitmap.isEmpty();
    }

    @Override
    public long getCardinality() {
        return this.roaringBitmap.getCardinality();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] serializeToBytes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DeletionVector deserializeFromDataInput(DataInput bis) throws IOException {
        RoaringBitmap32 roaringBitmap = new RoaringBitmap32();
        roaringBitmap.deserialize(bis);
        return new BitmapDeletionVector(roaringBitmap);
    }

    private void checkPosition(long position) {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The file has too many rows, RoaringBitmap32 only supports files with row count not exceeding 2147483647.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapDeletionVector that = (BitmapDeletionVector)o;
        return Objects.equals(this.roaringBitmap, that.roaringBitmap);
    }
}

