/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.ApplyDeletionFileRecordIterator;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.Preconditions;

public class ApplyDeletionVectorReader
implements RecordReader<InternalRow> {
    private final RecordReader<InternalRow> reader;
    private final DeletionVector deletionVector;

    public ApplyDeletionVectorReader(RecordReader<InternalRow> reader, DeletionVector deletionVector) {
        this.reader = reader;
        this.deletionVector = deletionVector;
    }

    public RecordReader<InternalRow> reader() {
        return this.reader;
    }

    public DeletionVector deletionVector() {
        return this.deletionVector;
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
        RecordReader.RecordIterator<InternalRow> batch = this.reader.readBatch();
        if (batch == null) {
            return null;
        }
        Preconditions.checkArgument(batch instanceof FileRecordIterator, "There is a bug, RecordIterator in ApplyDeletionVectorReader must be RecordWithPositionIterator");
        return new ApplyDeletionFileRecordIterator((FileRecordIterator)batch, this.deletionVector);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

