/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.OptionalUtils;

@Experimental
@JsonIgnoreProperties(ignoreUnknown=true)
public class Statistics {
    private static final String FIELD_SNAPSHOT_ID = "snapshotId";
    private static final String FIELD_SCHEMA_ID = "schemaId";
    private static final String FIELD_MERGED_RECORD_COUNT = "mergedRecordCount";
    private static final String FIELD_MERGED_RECORD_SIZE = "mergedRecordSize";
    private static final String FIELD_COL_STATS = "colStats";
    @JsonProperty(value="snapshotId")
    private final long snapshotId;
    @JsonProperty(value="schemaId")
    private final long schemaId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="mergedRecordCount")
    @Nullable
    private final Long mergedRecordCount;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="mergedRecordSize")
    @Nullable
    private final Long mergedRecordSize;
    @JsonProperty(value="colStats")
    private final Map<String, ColStats<?>> colStats;

    @JsonCreator
    public Statistics(@JsonProperty(value="snapshotId") long snapshotId, @JsonProperty(value="schemaId") long schemaId, @JsonProperty(value="mergedRecordCount") @Nullable Long mergedRecordCount, @JsonProperty(value="mergedRecordSize") @Nullable Long mergedRecordSize, @JsonProperty(value="colStats") Map<String, ColStats<?>> colStats) {
        this.snapshotId = snapshotId;
        this.schemaId = schemaId;
        this.mergedRecordCount = mergedRecordCount;
        this.mergedRecordSize = mergedRecordSize;
        this.colStats = colStats;
    }

    public Statistics(long snapshotId, long schemaId, Long mergedRecordCount, Long mergedRecordSize) {
        this(snapshotId, schemaId, mergedRecordCount, mergedRecordSize, Collections.emptyMap());
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public OptionalLong mergedRecordCount() {
        return OptionalUtils.ofNullable(this.mergedRecordCount);
    }

    public OptionalLong mergedRecordSize() {
        return OptionalUtils.ofNullable(this.mergedRecordSize);
    }

    public Map<String, ColStats<?>> colStats() {
        return this.colStats;
    }

    public void serializeFieldsToString(TableSchema schema) {
        try {
            if (this.colStats != null) {
                for (Map.Entry<String, ColStats<?>> entry : this.colStats.entrySet()) {
                    String colName = entry.getKey();
                    ColStats<?> colStats = entry.getValue();
                    DataType type = schema.fields().stream().filter(field -> field.name().equals(colName)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to obtain the latest schema")).type();
                    colStats.serializeFieldsToString(type);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to serialize fields to string", e);
        }
    }

    public void deserializeFieldsFromString(TableSchema schema) {
        try {
            if (this.colStats != null) {
                for (Map.Entry<String, ColStats<?>> entry : this.colStats.entrySet()) {
                    String colName = entry.getKey();
                    ColStats<?> colStats = entry.getValue();
                    DataType type = schema.fields().stream().filter(field -> field.name().equals(colName)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to obtain the latest schema")).type();
                    colStats.deserializeFieldsFromString(type);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to deserialize fields from string", e);
        }
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public static Statistics fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Statistics.class);
    }

    public static Statistics fromPath(FileIO fileIO, Path path) {
        try {
            String json = fileIO.readFileUtf8(path);
            return Statistics.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to read snapshot from path " + path, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statistics stats = (Statistics)o;
        return this.snapshotId == stats.snapshotId && this.schemaId == stats.schemaId && Objects.equals(this.mergedRecordCount, stats.mergedRecordCount) && Objects.equals(this.mergedRecordSize, stats.mergedRecordSize) && Objects.equals(this.colStats, stats.colStats);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.schemaId, this.mergedRecordCount, this.mergedRecordSize, this.colStats);
    }

    public String toString() {
        return JsonSerdeUtil.toJson(this);
    }
}

