/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.lookup.LookupStrategy;
import org.apache.paimon.mergetree.LookupLevels;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.LookupMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.UserDefinedSeqComparator;

public class LookupChangelogMergeFunctionWrapper<T>
implements MergeFunctionWrapper<ChangelogResult> {
    private final LookupMergeFunction mergeFunction;
    private final MergeFunction<KeyValue> mergeFunction2;
    private final Function<InternalRow, T> lookup;
    private final ChangelogResult reusedResult = new ChangelogResult();
    private final KeyValue reusedBefore = new KeyValue();
    private final KeyValue reusedAfter = new KeyValue();
    private final RecordEqualiser valueEqualiser;
    private final boolean changelogRowDeduplicate;
    private final LookupStrategy lookupStrategy;
    @Nullable
    private final DeletionVectorsMaintainer deletionVectorsMaintainer;
    private final Comparator<KeyValue> comparator;

    public LookupChangelogMergeFunctionWrapper(MergeFunctionFactory<KeyValue> mergeFunctionFactory, Function<InternalRow, T> lookup, RecordEqualiser valueEqualiser, boolean changelogRowDeduplicate, LookupStrategy lookupStrategy, @Nullable DeletionVectorsMaintainer deletionVectorsMaintainer, @Nullable UserDefinedSeqComparator userDefinedSeqComparator) {
        MergeFunction<KeyValue> mergeFunction = mergeFunctionFactory.create();
        Preconditions.checkArgument(mergeFunction instanceof LookupMergeFunction, "Merge function should be a LookupMergeFunction, but is %s, there is a bug.", mergeFunction.getClass().getName());
        if (lookupStrategy.deletionVector) {
            Preconditions.checkArgument(deletionVectorsMaintainer != null, "deletionVectorsMaintainer should not be null, there is a bug.");
        }
        this.mergeFunction = (LookupMergeFunction)mergeFunction;
        this.mergeFunction2 = mergeFunctionFactory.create();
        this.lookup = lookup;
        this.valueEqualiser = valueEqualiser;
        this.changelogRowDeduplicate = changelogRowDeduplicate;
        this.lookupStrategy = lookupStrategy;
        this.deletionVectorsMaintainer = deletionVectorsMaintainer;
        this.comparator = this.createSequenceComparator(userDefinedSeqComparator);
    }

    @Override
    public void reset() {
        this.mergeFunction.reset();
    }

    @Override
    public void add(KeyValue kv) {
        this.mergeFunction.add(kv);
    }

    @Override
    public ChangelogResult getResult() {
        InternalRow lookupKey;
        T lookupResult;
        LinkedList<KeyValue> candidates = this.mergeFunction.candidates();
        Iterator<KeyValue> descending = candidates.descendingIterator();
        KeyValue highLevel = null;
        boolean containLevel0 = false;
        while (descending.hasNext()) {
            KeyValue kv = descending.next();
            if (kv.level() > 0) {
                descending.remove();
                if (highLevel != null) continue;
                highLevel = kv;
                continue;
            }
            containLevel0 = true;
        }
        if (highLevel == null && (lookupResult = this.lookup.apply(lookupKey = candidates.get(0).key())) != null) {
            if (this.lookupStrategy.deletionVector) {
                LookupLevels.PositionedKeyValue positionedKeyValue = (LookupLevels.PositionedKeyValue)lookupResult;
                highLevel = positionedKeyValue.keyValue();
                this.deletionVectorsMaintainer.notifyNewDeletion(positionedKeyValue.fileName(), positionedKeyValue.rowPosition());
            } else {
                highLevel = (KeyValue)lookupResult;
            }
        }
        KeyValue result = this.calculateResult(candidates, highLevel);
        this.reusedResult.reset();
        if (containLevel0 && this.lookupStrategy.produceChangelog) {
            this.setChangelog(highLevel, result);
        }
        return this.reusedResult.setResult(result);
    }

    private KeyValue calculateResult(List<KeyValue> candidates, @Nullable KeyValue highLevel) {
        this.mergeFunction2.reset();
        for (KeyValue candidate : candidates) {
            if (highLevel != null && this.comparator.compare(highLevel, candidate) < 0) {
                this.mergeFunction2.add(highLevel);
                this.mergeFunction2.add(candidate);
                highLevel = null;
                continue;
            }
            this.mergeFunction2.add(candidate);
        }
        if (highLevel != null) {
            this.mergeFunction2.add(highLevel);
        }
        return this.mergeFunction2.getResult();
    }

    private void setChangelog(@Nullable KeyValue before, KeyValue after) {
        if (before == null || !before.isAdd()) {
            if (after.isAdd()) {
                this.reusedResult.addChangelog(this.replaceAfter(RowKind.INSERT, after));
            }
        } else if (!after.isAdd()) {
            this.reusedResult.addChangelog(this.replaceBefore(RowKind.DELETE, before));
        } else if (!this.changelogRowDeduplicate || !this.valueEqualiser.equals(before.value(), after.value())) {
            this.reusedResult.addChangelog(this.replaceBefore(RowKind.UPDATE_BEFORE, before)).addChangelog(this.replaceAfter(RowKind.UPDATE_AFTER, after));
        }
    }

    private KeyValue replaceBefore(RowKind valueKind, KeyValue from) {
        return this.replace(this.reusedBefore, valueKind, from);
    }

    private KeyValue replaceAfter(RowKind valueKind, KeyValue from) {
        return this.replace(this.reusedAfter, valueKind, from);
    }

    private KeyValue replace(KeyValue reused, RowKind valueKind, KeyValue from) {
        return reused.replace(from.key(), from.sequenceNumber(), valueKind, from.value());
    }

    private Comparator<KeyValue> createSequenceComparator(@Nullable FieldsComparator userDefinedSeqComparator) {
        if (userDefinedSeqComparator == null) {
            return Comparator.comparingLong(KeyValue::sequenceNumber);
        }
        return (o1, o2) -> {
            int result = userDefinedSeqComparator.compare(o1.value(), o2.value());
            if (result != 0) {
                return result;
            }
            return Long.compare(o1.sequenceNumber(), o2.sequenceNumber());
        };
    }
}

