/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializer;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;

public class PendingSplitsCheckpointSerializer
implements SimpleVersionedSerializer<PendingSplitsCheckpoint> {
    private static final long INVALID_SNAPSHOT = -1L;
    private final FileStoreSourceSplitSerializer splitSerializer;

    public PendingSplitsCheckpointSerializer(FileStoreSourceSplitSerializer splitSerializer) {
        this.splitSerializer = splitSerializer;
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PendingSplitsCheckpoint pendingSplitsCheckpoint) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        view.writeInt(pendingSplitsCheckpoint.splits().size());
        for (FileStoreSourceSplit split : pendingSplitsCheckpoint.splits()) {
            byte[] bytes = this.splitSerializer.serialize(split);
            view.writeInt(bytes.length);
            view.write(bytes);
        }
        Long currentSnapshotId = pendingSplitsCheckpoint.currentSnapshotId();
        view.writeLong(currentSnapshotId == null ? -1L : currentSnapshotId);
        return out.toByteArray();
    }

    public PendingSplitsCheckpoint deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        int splitNumber = view.readInt();
        ArrayList<FileStoreSourceSplit> splits = new ArrayList<FileStoreSourceSplit>(splitNumber);
        for (int i = 0; i < splitNumber; ++i) {
            int byteNumber = view.readInt();
            byte[] bytes = new byte[byteNumber];
            view.readFully(bytes);
            splits.add(this.splitSerializer.deserialize(version, bytes));
        }
        long currentSnapshotId = view.readLong();
        return new PendingSplitsCheckpoint(splits, currentSnapshotId == -1L ? null : Long.valueOf(currentSnapshotId));
    }
}

