/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.MutableRecordAndPosition;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkRowData;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FlinkRecordsWithSplitIds;
import org.apache.paimon.flink.source.RecordLimiter;
import org.apache.paimon.flink.source.metrics.FileStoreSourceReaderMetrics;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;

public class FileStoreSourceSplitReader
implements SplitReader<BulkFormat.RecordIterator<RowData>, FileStoreSourceSplit> {
    private final TableRead tableRead;
    @Nullable
    private final RecordLimiter limiter;
    private final Queue<FileStoreSourceSplit> splits;
    private final Pool<FileStoreRecordIterator> pool;
    @Nullable
    private LazyRecordReader currentReader;
    @Nullable
    private String currentSplitId;
    private long currentNumRead;
    private RecordReader.RecordIterator<InternalRow> currentFirstBatch;
    private boolean paused;
    private final FileStoreSourceReaderMetrics metrics;

    public FileStoreSourceSplitReader(TableRead tableRead, @Nullable RecordLimiter limiter, FileStoreSourceReaderMetrics metrics) {
        this.tableRead = tableRead;
        this.limiter = limiter;
        this.splits = new LinkedList<FileStoreSourceSplit>();
        this.pool = new Pool(1);
        this.pool.add((Object)new FileStoreRecordIterator());
        this.paused = false;
        this.metrics = metrics;
    }

    public RecordsWithSplitIds<BulkFormat.RecordIterator<RowData>> fetch() throws IOException {
        RecordReader.RecordIterator<InternalRow> nextBatch;
        if (this.paused) {
            return new RecordsWithPausedSplit<BulkFormat.RecordIterator<RowData>>();
        }
        this.checkSplitOrStartNext();
        FileStoreRecordIterator iterator = this.pool();
        if (this.currentFirstBatch != null) {
            nextBatch = this.currentFirstBatch;
            this.currentFirstBatch = null;
        } else {
            RecordReader.RecordIterator<InternalRow> recordIterator = nextBatch = this.reachLimit() ? null : Objects.requireNonNull(this.currentReader).recordReader().readBatch();
        }
        if (nextBatch == null) {
            this.pool.recycler().recycle((Object)iterator);
            return this.finishSplit();
        }
        return FlinkRecordsWithSplitIds.forRecords(this.currentSplitId, iterator.replace(nextBatch));
    }

    private boolean reachLimit() {
        return this.limiter != null && this.limiter.reachLimit();
    }

    private FileStoreRecordIterator pool() throws IOException {
        try {
            return (FileStoreRecordIterator)this.pool.pollEntry();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted");
        }
    }

    public void handleSplitsChanges(SplitsChange<FileStoreSourceSplit> splitsChange) {
        if (!(splitsChange instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChange.getClass()));
        }
        this.splits.addAll(splitsChange.splits());
    }

    public void pauseOrResumeSplits(Collection<FileStoreSourceSplit> splitsToPause, Collection<FileStoreSourceSplit> splitsToResume) {
        for (FileStoreSourceSplit split : splitsToPause) {
            if (!split.splitId().equals(this.currentSplitId)) continue;
            this.paused = true;
            break;
        }
        for (FileStoreSourceSplit split : splitsToResume) {
            if (!split.splitId().equals(this.currentSplitId)) continue;
            this.paused = false;
            break;
        }
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        if (this.currentReader != null && this.currentReader.lazyRecordReader != null) {
            this.currentReader.lazyRecordReader.close();
        }
    }

    private void checkSplitOrStartNext() throws IOException {
        if (this.currentReader != null) {
            return;
        }
        FileStoreSourceSplit nextSplit = this.splits.poll();
        if (nextSplit == null) {
            throw new IOException("Cannot fetch from another split - no split remaining");
        }
        if (nextSplit.split() instanceof DataSplit) {
            long eventTime = ((DataSplit)nextSplit.split()).latestFileCreationEpochMillis().orElse(-1L);
            this.metrics.recordSnapshotUpdate(eventTime);
        }
        this.currentSplitId = nextSplit.splitId();
        this.currentReader = new LazyRecordReader(nextSplit.split());
        this.currentNumRead = nextSplit.recordsToSkip();
        if (this.limiter != null) {
            this.limiter.add(this.currentNumRead);
        }
        if (this.currentNumRead > 0L) {
            this.seek(this.currentNumRead);
        }
    }

    private void seek(long toSkip) throws IOException {
        while (true) {
            RecordReader.RecordIterator<InternalRow> nextBatch;
            if ((nextBatch = Objects.requireNonNull(this.currentReader).recordReader().readBatch()) == null) {
                throw new RuntimeException(String.format("skip(%s) more than the number of remaining elements.", toSkip));
            }
            while (toSkip > 0L && nextBatch.next() != null) {
                --toSkip;
            }
            if (toSkip == 0L) {
                this.currentFirstBatch = nextBatch;
                return;
            }
            nextBatch.releaseBatch();
        }
    }

    private FlinkRecordsWithSplitIds finishSplit() throws IOException {
        if (this.currentReader != null) {
            if (this.currentReader.lazyRecordReader != null) {
                this.currentReader.lazyRecordReader.close();
            }
            this.currentReader = null;
        }
        FlinkRecordsWithSplitIds finishRecords = FlinkRecordsWithSplitIds.finishedSplit(this.currentSplitId);
        this.currentSplitId = null;
        return finishRecords;
    }

    private static class RecordsWithPausedSplit<T>
    implements RecordsWithSplitIds<T> {
        private RecordsWithPausedSplit() {
        }

        @Nullable
        public String nextSplit() {
            return null;
        }

        @Nullable
        public T nextRecordFromSplit() {
            return null;
        }

        public Set<String> finishedSplits() {
            return Collections.emptySet();
        }
    }

    private class LazyRecordReader {
        private final Split split;
        private RecordReader<InternalRow> lazyRecordReader;

        private LazyRecordReader(Split split) {
            this.split = split;
        }

        public RecordReader<InternalRow> recordReader() throws IOException {
            if (this.lazyRecordReader == null) {
                this.lazyRecordReader = FileStoreSourceSplitReader.this.tableRead.createReader(this.split);
            }
            return this.lazyRecordReader;
        }
    }

    private class FileStoreRecordIterator
    implements BulkFormat.RecordIterator<RowData> {
        private RecordReader.RecordIterator<InternalRow> iterator;
        private final MutableRecordAndPosition<RowData> recordAndPosition = new MutableRecordAndPosition();

        private FileStoreRecordIterator() {
        }

        public FileStoreRecordIterator replace(RecordReader.RecordIterator<InternalRow> iterator) {
            this.iterator = iterator;
            this.recordAndPosition.set(null, -1L, FileStoreSourceSplitReader.this.currentNumRead);
            return this;
        }

        @Nullable
        public RecordAndPosition<RowData> next() {
            InternalRow row;
            if (FileStoreSourceSplitReader.this.reachLimit()) {
                return null;
            }
            try {
                row = this.iterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (row == null) {
                return null;
            }
            this.recordAndPosition.setNext((Object)new FlinkRowData(row));
            FileStoreSourceSplitReader.this.currentNumRead++;
            if (FileStoreSourceSplitReader.this.limiter != null) {
                FileStoreSourceSplitReader.this.limiter.increment();
            }
            return this.recordAndPosition;
        }

        public void releaseBatch() {
            this.iterator.releaseBatch();
            FileStoreSourceSplitReader.this.pool.recycler().recycle((Object)this);
        }
    }
}

