/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.AdaptiveParallelism;
import org.apache.paimon.flink.sink.AsyncLookupSinkWrite;
import org.apache.paimon.flink.sink.AutoTagForSavepointCommitterOperator;
import org.apache.paimon.flink.sink.BatchWriteGeneratorTagOperator;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.CommittableTypeInfo;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.CommitterOperator;
import org.apache.paimon.flink.sink.GlobalFullCompactionSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.utils.ManagedMemoryUtils;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializableRunnable;

public abstract class FlinkSink<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WRITER_NAME = "Writer";
    private static final String WRITER_WRITE_ONLY_NAME = "Writer(write-only)";
    private static final String GLOBAL_COMMITTER_NAME = "Global Committer";
    protected final FileStoreTable table;
    private final boolean ignorePreviousFiles;

    public FlinkSink(FileStoreTable table, boolean ignorePreviousFiles) {
        this.table = table;
        this.ignorePreviousFiles = ignorePreviousFiles;
    }

    private StoreSinkWrite.Provider createWriteProvider(CheckpointConfig checkpointConfig, boolean isStreaming, boolean hasSinkMaterializer) {
        boolean waitCompaction;
        SerializableRunnable assertNoSinkMaterializer = () -> Preconditions.checkArgument(!hasSinkMaterializer, String.format("Sink materializer must not be used with Paimon sink. Please set '%s' to '%s' in Flink's config.", ExecutionConfigOptions.TABLE_EXEC_SINK_UPSERT_MATERIALIZE.key(), ExecutionConfigOptions.UpsertMaterialize.NONE.name()));
        Options options = this.table.coreOptions().toConfiguration();
        CoreOptions.ChangelogProducer changelogProducer = this.table.coreOptions().changelogProducer();
        if (this.table.coreOptions().writeOnly()) {
            waitCompaction = false;
        } else {
            waitCompaction = FlinkConnectorOptions.prepareCommitWaitCompaction(options);
            int deltaCommits = -1;
            if (options.contains(CoreOptions.FULL_COMPACTION_DELTA_COMMITS)) {
                deltaCommits = options.get(CoreOptions.FULL_COMPACTION_DELTA_COMMITS);
            } else if (options.contains(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL)) {
                long fullCompactionThresholdMs = options.get(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL).toMillis();
                deltaCommits = (int)(fullCompactionThresholdMs / checkpointConfig.getCheckpointInterval());
            }
            if (changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION || deltaCommits >= 0) {
                int finalDeltaCommits = Math.max(deltaCommits, 1);
                return (table, commitUser, state, ioManager, memoryPool, metricGroup) -> {
                    assertNoSinkMaterializer.run();
                    return new GlobalFullCompactionSinkWrite(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, finalDeltaCommits, isStreaming, memoryPool, metricGroup);
                };
            }
        }
        if (changelogProducer == CoreOptions.ChangelogProducer.LOOKUP && !options.get(FlinkConnectorOptions.CHANGELOG_PRODUCER_LOOKUP_WAIT).booleanValue()) {
            return (table, commitUser, state, ioManager, memoryPool, metricGroup) -> {
                assertNoSinkMaterializer.run();
                return new AsyncLookupSinkWrite(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, isStreaming, memoryPool, metricGroup);
            };
        }
        return (table, commitUser, state, ioManager, memoryPool, metricGroup) -> {
            assertNoSinkMaterializer.run();
            return new StoreSinkWriteImpl(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, isStreaming, memoryPool, metricGroup);
        };
    }

    public DataStreamSink<?> sinkFrom(DataStream<T> input) {
        String initialCommitUser = UUID.randomUUID().toString();
        return this.sinkFrom(input, initialCommitUser);
    }

    public DataStreamSink<?> sinkFrom(DataStream<T> input, String initialCommitUser) {
        DataStream<Committable> written = this.doWrite(input, initialCommitUser, input.getParallelism());
        return this.doCommit(written, initialCommitUser);
    }

    private boolean hasSinkMaterializer(DataStream<T> input) {
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Transformation> queue = new LinkedList<Transformation>();
        queue.add(input.getTransformation());
        visited.add(input.getTransformation().getId());
        while (!queue.isEmpty()) {
            Transformation transformation = (Transformation)queue.poll();
            if (transformation.getName().startsWith("SinkMaterializer")) {
                return true;
            }
            for (Transformation prev : transformation.getInputs()) {
                if (visited.contains(prev.getId())) continue;
                queue.add(prev);
                visited.add(prev.getId());
            }
        }
        return false;
    }

    public DataStream<Committable> doWrite(DataStream<T> input, String commitUser, @Nullable Integer parallelism) {
        Options options;
        StreamExecutionEnvironment env = input.getExecutionEnvironment();
        boolean isStreaming = FlinkSink.isStreaming(input);
        boolean writeOnly = this.table.coreOptions().writeOnly();
        SingleOutputStreamOperator written = input.transform((writeOnly ? WRITER_WRITE_ONLY_NAME : WRITER_NAME) + " : " + this.table.name(), (TypeInformation)new CommittableTypeInfo(), this.createWriteOperator(this.createWriteProvider(env.getCheckpointConfig(), isStreaming, this.hasSinkMaterializer(input)), commitUser)).setParallelism(parallelism == null ? input.getParallelism() : parallelism.intValue());
        if (!isStreaming) {
            this.assertBatchConfiguration(env, written.getParallelism());
        }
        if ((options = Options.fromMap(this.table.options())).get(FlinkConnectorOptions.SINK_USE_MANAGED_MEMORY).booleanValue()) {
            ManagedMemoryUtils.declareManagedMemory(written, options.get(FlinkConnectorOptions.SINK_MANAGED_WRITER_BUFFER_MEMORY));
        }
        return written;
    }

    protected DataStreamSink<?> doCommit(DataStream<Committable> written, String commitUser) {
        boolean streamingCheckpointEnabled;
        StreamExecutionEnvironment env = written.getExecutionEnvironment();
        ReadableConfig conf = env.getConfiguration();
        CheckpointConfig checkpointConfig = env.getCheckpointConfig();
        boolean bl = streamingCheckpointEnabled = FlinkSink.isStreaming(written) && checkpointConfig.isCheckpointingEnabled();
        if (streamingCheckpointEnabled) {
            FlinkSink.assertStreamingConfiguration(env);
        }
        BoundedOneInput committerOperator = new CommitterOperator<Committable, ManifestCommittable>(streamingCheckpointEnabled, true, commitUser, this.createCommitterFactory(streamingCheckpointEnabled), this.createCommittableStateManager());
        if (Options.fromMap(this.table.options()).get(FlinkConnectorOptions.SINK_AUTO_TAG_FOR_SAVEPOINT).booleanValue()) {
            committerOperator = new AutoTagForSavepointCommitterOperator<Committable, ManifestCommittable>((CommitterOperator<Committable, ManifestCommittable>)committerOperator, this.table::snapshotManager, this.table::tagManager, () -> this.table.store().newTagDeletion(), () -> this.table.store().createTagCallbacks(), this.table.coreOptions().tagDefaultTimeRetained());
        }
        if (conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.BATCH && this.table.coreOptions().tagCreationMode() == CoreOptions.TagCreationMode.BATCH) {
            committerOperator = new BatchWriteGeneratorTagOperator<Committable, ManifestCommittable>((CommitterOperator<Committable, ManifestCommittable>)committerOperator, this.table);
        }
        SingleOutputStreamOperator committed = written.transform("Global Committer : " + this.table.name(), (TypeInformation)new CommittableTypeInfo(), committerOperator).setParallelism(1).setMaxParallelism(1);
        Options options = Options.fromMap(this.table.options());
        FlinkSink.configureGlobalCommitter(committed, options.get(FlinkConnectorOptions.SINK_COMMITTER_CPU), options.get(FlinkConnectorOptions.SINK_COMMITTER_MEMORY));
        return committed.addSink((SinkFunction)new DiscardingSink()).name("end").setParallelism(1);
    }

    public static void configureGlobalCommitter(SingleOutputStreamOperator<?> committed, double cpuCores, @Nullable MemorySize heapMemory) {
        if (heapMemory == null) {
            return;
        }
        SlotSharingGroup slotSharingGroup = SlotSharingGroup.newBuilder((String)committed.getName()).setCpuCores(cpuCores).setTaskHeapMemory(new org.apache.flink.configuration.MemorySize(heapMemory.getBytes())).build();
        committed.slotSharingGroup(slotSharingGroup);
    }

    public static void assertStreamingConfiguration(StreamExecutionEnvironment env) {
        Preconditions.checkArgument(!env.getCheckpointConfig().isUnalignedCheckpointsEnabled(), "Paimon sink currently does not support unaligned checkpoints. Please set " + ExecutionCheckpointingOptions.ENABLE_UNALIGNED.key() + " to false.");
        Preconditions.checkArgument(env.getCheckpointConfig().getCheckpointingMode() == CheckpointingMode.EXACTLY_ONCE, "Paimon sink currently only supports EXACTLY_ONCE checkpoint mode. Please set " + ExecutionCheckpointingOptions.CHECKPOINTING_MODE.key() + " to exactly-once");
    }

    private void assertBatchConfiguration(StreamExecutionEnvironment env, int sinkParallelism) {
        try {
            Preconditions.checkArgument(sinkParallelism != -1 || !AdaptiveParallelism.isEnabled(env), "Paimon Sink does not support Flink's Adaptive Parallelism mode. Please manually turn it off or set Paimon `sink.parallelism` manually.");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected abstract OneInputStreamOperator<T, Committable> createWriteOperator(StoreSinkWrite.Provider var1, String var2);

    protected abstract Committer.Factory<Committable, ManifestCommittable> createCommitterFactory(boolean var1);

    protected abstract CommittableStateManager<ManifestCommittable> createCommittableStateManager();

    public static boolean isStreaming(DataStream<?> input) {
        return FlinkSink.isStreaming(input.getExecutionEnvironment());
    }

    public static boolean isStreaming(StreamExecutionEnvironment env) {
        return env.getConfiguration().get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
    }
}

