/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.safe;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.safe.SafeBinaryArray;
import org.apache.paimon.memory.BytesUtils;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public final class SafeBinaryRow
implements InternalRow {
    private final int arity;
    private final int nullBitsSizeInBytes;
    private final byte[] bytes;
    private final int offset;

    public SafeBinaryRow(int arity, byte[] bytes, int offset) {
        Preconditions.checkArgument(arity >= 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
        this.bytes = bytes;
        this.offset = offset;
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    @Override
    public int getFieldCount() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        byte kindValue = this.bytes[this.offset];
        return RowKind.fromByteValue(kindValue);
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.bytes[this.offset] = kind.toByteValue();
    }

    @Override
    public boolean isNullAt(int pos) {
        int index = pos + 8;
        int offset = this.offset + MemorySegmentUtils.byteIndex(index);
        byte current = this.bytes[offset];
        return (current & 1 << (index & 7)) != 0;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.bytes[this.getFieldOffset(pos)] != 0;
    }

    @Override
    public byte getByte(int pos) {
        return this.bytes[this.getFieldOffset(pos)];
    }

    @Override
    public short getShort(int pos) {
        return BytesUtils.getShort(this.bytes, this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        return BytesUtils.getInt(this.bytes, this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        return BytesUtils.getLong(this.bytes, this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        return Float.intBitsToFloat(this.getInt(pos));
    }

    @Override
    public double getDouble(int pos) {
        return Double.longBitsToDouble(this.getLong(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        return BinaryString.fromBytes(this.getBinary(pos));
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        long longValue = this.getLong(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(longValue, precision, scale);
        }
        int size = (int)longValue;
        int subOffset = (int)(longValue >> 32);
        byte[] decimalBytes = new byte[size];
        System.arraycopy(this.bytes, this.offset + subOffset, decimalBytes, 0, size);
        return Decimal.fromUnscaledBytes(decimalBytes, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        long longValue = this.getLong(pos);
        if (Timestamp.isCompact(precision)) {
            return Timestamp.fromEpochMillis(longValue);
        }
        int nanoOfMillisecond = (int)longValue;
        int subOffset = (int)(longValue >> 32);
        Preconditions.checkArgument(this.bytes.length >= this.offset + subOffset + 8);
        long millisecond = BytesUtils.getLong(this.bytes, this.offset + subOffset);
        return Timestamp.fromEpochMillis(millisecond, nanoOfMillisecond);
    }

    @Override
    public byte[] getBinary(int pos) {
        return BytesUtils.readBinary(this.bytes, this.offset, this.getFieldOffset(pos), this.getLong(pos));
    }

    @Override
    public InternalArray getArray(int pos) {
        return SafeBinaryRow.readArrayData(this.bytes, this.offset, this.getLong(pos));
    }

    private static InternalArray readArrayData(byte[] bytes, int baseOffset, long offsetAndSize) {
        int offset = (int)(offsetAndSize >> 32);
        return new SafeBinaryArray(bytes, offset + baseOffset);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return SafeBinaryRow.readNestedRow(this.bytes, numFields, this.offset, this.getLong(pos));
    }

    private static InternalRow readNestedRow(byte[] bytes, int numFields, int baseOffset, long offsetAndSize) {
        int offset = (int)(offsetAndSize >> 32);
        return new SafeBinaryRow(numFields, bytes, offset + baseOffset);
    }

    @Override
    public InternalMap getMap(int pos) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

