/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.netty4.io.netty.handler.codec.sctp;

import java.util.List;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.paimon.shade.netty4.io.netty.channel.sctp.SctpMessage;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.CodecException;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.sctp.SctpMessageCompletionHandler;

public class SctpInboundByteStreamHandler
extends MessageToMessageDecoder<SctpMessage> {
    private final int protocolIdentifier;
    private final int streamIdentifier;

    public SctpInboundByteStreamHandler(int protocolIdentifier, int streamIdentifier) {
        this.protocolIdentifier = protocolIdentifier;
        this.streamIdentifier = streamIdentifier;
    }

    @Override
    public final boolean acceptInboundMessage(Object msg) throws Exception {
        if (super.acceptInboundMessage(msg)) {
            return this.acceptInboundMessage((SctpMessage)msg);
        }
        return false;
    }

    protected boolean acceptInboundMessage(SctpMessage msg) {
        return msg.protocolIdentifier() == this.protocolIdentifier && msg.streamIdentifier() == this.streamIdentifier;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, SctpMessage msg, List<Object> out) throws Exception {
        if (!msg.isComplete()) {
            throw new CodecException(String.format("Received SctpMessage is not complete, please add %s in the pipeline before this handler", SctpMessageCompletionHandler.class.getSimpleName()));
        }
        out.add(msg.content().retain());
    }
}

