/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.io.FileWriter;
import org.apache.paimon.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleFileWriter<T, R>
implements FileWriter<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileWriter.class);
    protected final FileIO fileIO;
    protected final Path path;
    private final Function<T, InternalRow> converter;
    private final FormatWriter writer;
    private PositionOutputStream out;
    private long recordCount;
    protected boolean closed;

    public SingleFileWriter(FileIO fileIO, FormatWriterFactory factory, Path path, Function<T, InternalRow> converter, String compression) {
        this.fileIO = fileIO;
        this.path = path;
        this.converter = converter;
        try {
            this.out = fileIO.newOutputStream(path, false);
            this.writer = factory.create(this.out, compression);
        }
        catch (IOException e) {
            LOG.warn("Failed to open the bulk writer, closing the output stream and throw the error.", (Throwable)e);
            if (this.out != null) {
                this.abort();
            }
            throw new UncheckedIOException(e);
        }
        this.recordCount = 0L;
        this.closed = false;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public void write(T record) throws IOException {
        this.writeImpl(record);
    }

    protected InternalRow writeImpl(T record) throws IOException {
        if (this.closed) {
            throw new RuntimeException("Writer has already closed!");
        }
        try {
            InternalRow rowData = this.converter.apply(record);
            this.writer.addElement(rowData);
            ++this.recordCount;
            return rowData;
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + this.path + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        return this.writer.reachTargetSize(suggestedCheck, targetSize);
    }

    @Override
    public void abort() {
        IOUtils.closeQuietly(this.out);
        this.fileIO.deleteQuietly(this.path);
    }

    public AbortExecutor abortExecutor() {
        if (!this.closed) {
            throw new RuntimeException("Writer should be closed!");
        }
        return new AbortExecutor(this.fileIO, this.path);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing file " + this.path);
        }
        try {
            this.writer.flush();
            this.writer.finish();
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when closing file " + this.path + ". Cleaning up.", (Throwable)e);
            this.abort();
            throw e;
        }
        finally {
            this.closed = true;
        }
    }

    public static class AbortExecutor {
        private final FileIO fileIO;
        private final Path path;

        private AbortExecutor(FileIO fileIO, Path path) {
            this.fileIO = fileIO;
            this.path = path;
        }

        public void abort() {
            this.fileIO.deleteQuietly(this.path);
        }
    }
}

