/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.FlinkSink;
import org.apache.paimon.flink.sink.NoopCommittableStateManager;
import org.apache.paimon.flink.sink.StoreCommitter;
import org.apache.paimon.flink.sink.StoreCompactOperator;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.table.FileStoreTable;

public class CompactorSink
extends FlinkSink<RowData> {
    private static final long serialVersionUID = 1L;

    public CompactorSink(FileStoreTable table) {
        super(table, false);
    }

    @Override
    protected OneInputStreamOperator<RowData, Committable> createWriteOperator(StoreSinkWrite.Provider writeProvider, String commitUser) {
        return new StoreCompactOperator(this.table, writeProvider, commitUser);
    }

    @Override
    protected Committer.Factory<Committable, ManifestCommittable> createCommitterFactory(boolean streamingCheckpointEnabled) {
        return (user, metricGroup) -> new StoreCommitter(this.table.newCommit(user), metricGroup);
    }

    @Override
    protected CommittableStateManager<ManifestCommittable> createCommittableStateManager() {
        return new NoopCommittableStateManager();
    }
}

