/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.table.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackToAction
extends TableActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(RollbackToAction.class);
    private final String version;

    public RollbackToAction(String warehouse, String databaseName, String tableName, String version, Map<String, String> catalogConfig) {
        super(warehouse, databaseName, tableName, catalogConfig);
        this.version = version;
    }

    @Override
    public void run() throws Exception {
        LOG.debug("Run rollback-to action with snapshot id '{}'.", (Object)this.version);
        if (!(this.table instanceof DataTable)) {
            throw new IllegalArgumentException("Unknown table: " + this.identifier);
        }
        if (this.version.chars().allMatch(Character::isDigit)) {
            this.table.rollbackTo(Long.parseLong(this.version));
        } else {
            this.table.rollbackTo(this.version);
        }
    }
}

