/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen.codesplit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.codegen.codesplit.CodeSplitUtil;
import org.apache.paimon.codegen.codesplit.JavaLexer;
import org.apache.paimon.codegen.codesplit.JavaParser;
import org.apache.paimon.codegen.codesplit.ReturnAndJumpCounter;
import org.apache.paimon.shade.org.antlr.v4.runtime.CharStreams;
import org.apache.paimon.shade.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.paimon.shade.org.antlr.v4.runtime.ParserRuleContext;
import org.apache.paimon.shade.org.antlr.v4.runtime.Token;
import org.apache.paimon.shade.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.paimon.utils.Pair;

public class BlockStatementGrouper {
    private final String code;
    private final long maxMethodLength;
    private final String parameters;

    public BlockStatementGrouper(String code, long maxMethodLength, String parameters) {
        this.code = code;
        this.maxMethodLength = maxMethodLength;
        this.parameters = parameters;
    }

    public RewriteGroupedCode rewrite(String context) {
        BlockStatementGrouperVisitor visitor = new BlockStatementGrouperVisitor(this.maxMethodLength, this.parameters);
        CommonTokenStream tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(this.code)));
        JavaParser javaParser = new JavaParser(tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        TokenStreamRewriter rewriter = new TokenStreamRewriter(tokenStream);
        visitor.visitStatement(javaParser.statement(), context, rewriter);
        visitor.rewrite();
        Map groups = visitor.groups;
        HashMap<String, List<String>> groupStrings = new HashMap<String, List<String>>(groups.size());
        for (Map.Entry group : groups.entrySet()) {
            List collectedStringGroups = ((List)((Pair)group.getValue()).getValue()).stream().map(LocalGroupElement::getBody).collect(Collectors.toList());
            groupStrings.put((String)group.getKey(), collectedStringGroups);
        }
        return new RewriteGroupedCode(rewriter.getText(), groupStrings);
    }

    public static class RewriteGroupedCode {
        private final String rewriteCode;
        private final Map<String, List<String>> groups;

        public RewriteGroupedCode(String rewriteCode, Map<String, List<String>> groups) {
            this.rewriteCode = rewriteCode;
            this.groups = groups;
        }

        public String getRewriteCode() {
            return this.rewriteCode;
        }

        public Map<String, List<String>> getGroups() {
            return this.groups;
        }
    }

    private static class RewriteContextGroupElement
    implements LocalGroupElement {
        private final ParserRuleContext parserRuleContext;
        private final TokenStreamRewriter rewriter;

        private RewriteContextGroupElement(ParserRuleContext parserRuleContext, TokenStreamRewriter rewriter) {
            this.parserRuleContext = parserRuleContext;
            this.rewriter = rewriter;
        }

        @Override
        public Token getStart() {
            return this.parserRuleContext.start;
        }

        @Override
        public Token getStop() {
            return this.parserRuleContext.stop;
        }

        @Override
        public String getBody() {
            return this.rewriter.getText();
        }

        @Override
        public ParserRuleContext getContext() {
            return this.parserRuleContext;
        }
    }

    private static class ContextGroupElement
    implements LocalGroupElement {
        private final ParserRuleContext parserRuleContext;

        private ContextGroupElement(ParserRuleContext parserRuleContext) {
            this.parserRuleContext = parserRuleContext;
        }

        @Override
        public Token getStart() {
            return this.parserRuleContext.start;
        }

        @Override
        public Token getStop() {
            return this.parserRuleContext.stop;
        }

        @Override
        public String getBody() {
            return CodeSplitUtil.getContextString(this.parserRuleContext);
        }

        @Override
        public ParserRuleContext getContext() {
            return this.parserRuleContext;
        }
    }

    private static interface LocalGroupElement {
        public Token getStart();

        public Token getStop();

        public String getBody();

        public ParserRuleContext getContext();
    }

    private static class BlockStatementGrouperVisitor {
        private final Map<String, Pair<TokenStreamRewriter, List<LocalGroupElement>>> groups = new HashMap<String, Pair<TokenStreamRewriter, List<LocalGroupElement>>>();
        private final long maxMethodLength;
        private final String parameters;
        private int counter = 0;

        private BlockStatementGrouperVisitor(long maxMethodLength, String parameters) {
            this.maxMethodLength = maxMethodLength;
            this.parameters = parameters;
        }

        public void visitStatement(JavaParser.StatementContext ctx, String context, TokenStreamRewriter rewriter) {
            if (ctx.getChildCount() == 0) {
                return;
            }
            if (ctx.WHILE() != null || ctx.IF() != null || ctx.ELSE() != null) {
                for (JavaParser.StatementContext statement : ctx.statement()) {
                    if (!this.shouldExtract(statement)) continue;
                    String localContext = String.format("%s_%d", context, this.counter++);
                    this.groupBlock(statement, localContext, rewriter);
                }
            } else if (this.shouldExtract(ctx)) {
                this.groupBlock(ctx, context, rewriter);
            }
        }

        private void groupBlock(JavaParser.StatementContext ctx, String context, TokenStreamRewriter rewriter) {
            int localGroupCodeLength = 0;
            ArrayList<LocalGroupElement> localGroup = new ArrayList<LocalGroupElement>();
            for (JavaParser.BlockStatementContext bsc : ctx.block().blockStatement()) {
                JavaParser.StatementContext statement = bsc.statement();
                if (statement.IF() != null || statement.ELSE() != null || statement.WHILE() != null) {
                    String localContext = context + "_rewriteGroup" + this.counter++;
                    CommonTokenStream tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(CodeSplitUtil.getContextString(statement))));
                    TokenStreamRewriter localRewriter = new TokenStreamRewriter(tokenStream);
                    JavaParser javaParser = new JavaParser(tokenStream);
                    ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                    this.visitStatement(javaParser.statement(), localContext, localRewriter);
                    localGroup.add(new RewriteContextGroupElement(statement, localRewriter));
                    localGroupCodeLength += 3 + localContext.length() + this.parameters.length();
                    continue;
                }
                if ((long)(localGroupCodeLength + 1 + bsc.getText().length()) <= this.maxMethodLength) {
                    localGroup.add(new ContextGroupElement(bsc));
                    localGroupCodeLength += bsc.getText().length();
                    continue;
                }
                if (this.addLocalGroup(localGroup, context, rewriter)) {
                    localGroup = new ArrayList();
                    localGroupCodeLength = 0;
                }
                localGroupCodeLength += bsc.getText().length();
                localGroup.add(new ContextGroupElement(bsc));
            }
            this.addLocalGroup(localGroup, context, rewriter);
        }

        private boolean addLocalGroup(List<LocalGroupElement> localGroup, String context, TokenStreamRewriter rewriter) {
            if (localGroup.size() > 1 || localGroup.size() == 1 && this.canGroupAsSingleStatement(localGroup.get(0).getContext())) {
                String localContext = context + "_rewriteGroup" + this.counter++;
                this.groups.put(localContext, Pair.of(rewriter, localGroup));
                return true;
            }
            return false;
        }

        private boolean canGroupAsSingleStatement(ParserRuleContext context) {
            JavaParser.StatementContext statement;
            if (context instanceof JavaParser.StatementContext) {
                statement = (JavaParser.StatementContext)context;
            } else if (context instanceof JavaParser.BlockStatementContext) {
                statement = ((JavaParser.BlockStatementContext)context).statement();
            } else {
                return false;
            }
            return statement != null && (statement.IF() != null || statement.ELSE() != null || statement.WHILE() != null);
        }

        private boolean shouldExtract(JavaParser.StatementContext ctx) {
            return ctx != null && ctx.block() != null && ctx.block().blockStatement() != null && ctx.block().blockStatement().size() > 1 && this.getNumOfReturnOrJumpStatements(ctx.block()) == 0;
        }

        private int getNumOfReturnOrJumpStatements(ParserRuleContext ctx) {
            ReturnAndJumpCounter counter2 = new ReturnAndJumpCounter();
            counter2.visit(ctx);
            return counter2.getCounter();
        }

        private void rewrite() {
            for (Map.Entry<String, Pair<TokenStreamRewriter, List<LocalGroupElement>>> group : this.groups.entrySet()) {
                Pair<TokenStreamRewriter, List<LocalGroupElement>> pair = group.getValue();
                TokenStreamRewriter rewriter = pair.getKey();
                List<LocalGroupElement> value = pair.getValue();
                rewriter.replace(value.get(0).getStart(), value.get(value.size() - 1).getStop(), (Object)(group.getKey() + "(" + this.parameters + ");"));
            }
        }
    }
}

