/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.paimon.flink.sink.RowDataKeyAndBucketExtractor;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordKeyAndBucketExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.SchemaUtils;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DataTypesTest;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class CdcRecordKeyAndBucketExtractorTest {
    private static final RowType ROW_TYPE = RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"pt1", "pt2", "k1", "v1", "k2", "v2"});
    @TempDir
    java.nio.file.Path tempDir;

    @Test
    public void testExtract() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableSchema schema = this.createTableSchema();
        RowDataKeyAndBucketExtractor expected = new RowDataKeyAndBucketExtractor(schema);
        CdcRecordKeyAndBucketExtractor actual = new CdcRecordKeyAndBucketExtractor(schema);
        int numTests = random.nextInt(1000) + 1;
        for (int i = 0; i < numTests; ++i) {
            String pt1 = UUID.randomUUID().toString();
            int pt2 = random.nextInt();
            long k1 = random.nextLong();
            int v1 = random.nextInt();
            String k2 = UUID.randomUUID().toString();
            String v2 = UUID.randomUUID().toString();
            GenericRowData rowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)pt1), pt2, k1, v1, StringData.fromString((String)k2), StringData.fromString((String)v2)});
            expected.setRecord((RowData)rowData);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("pt1", pt1);
            data.put("pt2", String.valueOf(pt2));
            data.put("k1", String.valueOf(k1));
            data.put("v1", String.valueOf(v1));
            data.put("k2", k2);
            data.put("v2", v2);
            actual.setRecord(new CdcRecord(RowKind.INSERT, data));
            DataTypesTest.assertThat((Object)actual.partition()).isEqualTo((Object)expected.partition());
            DataTypesTest.assertThat((Object)actual.bucket()).isEqualTo((Object)expected.bucket());
            actual.setRecord(new CdcRecord(RowKind.DELETE, data));
            DataTypesTest.assertThat((Object)actual.partition()).isEqualTo((Object)expected.partition());
            DataTypesTest.assertThat((Object)actual.bucket()).isEqualTo((Object)expected.bucket());
        }
    }

    @Test
    public void testNullPartition() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableSchema schema = this.createTableSchema();
        RowDataKeyAndBucketExtractor expected = new RowDataKeyAndBucketExtractor(schema);
        CdcRecordKeyAndBucketExtractor actual = new CdcRecordKeyAndBucketExtractor(schema);
        long k1 = random.nextLong();
        int v1 = random.nextInt();
        String k2 = UUID.randomUUID().toString();
        String v2 = UUID.randomUUID().toString();
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{null, null, k1, v1, StringData.fromString((String)k2), StringData.fromString((String)v2)});
        expected.setRecord((RowData)rowData);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("pt1", null);
        data.put("pt2", null);
        data.put("k1", String.valueOf(k1));
        data.put("v1", String.valueOf(v1));
        data.put("k2", k2);
        data.put("v2", v2);
        actual.setRecord(new CdcRecord(RowKind.INSERT, data));
        DataTypesTest.assertThat((Object)actual.partition()).isEqualTo((Object)expected.partition());
        DataTypesTest.assertThat((Object)actual.bucket()).isEqualTo((Object)expected.bucket());
        actual.setRecord(new CdcRecord(RowKind.DELETE, data));
        DataTypesTest.assertThat((Object)actual.partition()).isEqualTo((Object)expected.partition());
        DataTypesTest.assertThat((Object)actual.bucket()).isEqualTo((Object)expected.bucket());
    }

    @Test
    public void testEmptyPartition() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableSchema schema = this.createTableSchema();
        RowDataKeyAndBucketExtractor expected = new RowDataKeyAndBucketExtractor(schema);
        CdcRecordKeyAndBucketExtractor actual = new CdcRecordKeyAndBucketExtractor(schema);
        long k1 = random.nextLong();
        int v1 = random.nextInt();
        String k2 = UUID.randomUUID().toString();
        String v2 = UUID.randomUUID().toString();
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)""), null, k1, v1, StringData.fromString((String)k2), StringData.fromString((String)v2)});
        expected.setRecord((RowData)rowData);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("pt1", "");
        data.put("pt2", null);
        data.put("k1", String.valueOf(k1));
        data.put("v1", String.valueOf(v1));
        data.put("k2", k2);
        data.put("v2", v2);
        actual.setRecord(new CdcRecord(RowKind.INSERT, data));
        DataTypesTest.assertThat((Object)actual.partition()).isEqualTo((Object)expected.partition());
        DataTypesTest.assertThat((Object)actual.bucket()).isEqualTo((Object)expected.bucket());
        actual.setRecord(new CdcRecord(RowKind.DELETE, data));
        DataTypesTest.assertThat((Object)actual.partition()).isEqualTo((Object)expected.partition());
        DataTypesTest.assertThat((Object)actual.bucket()).isEqualTo((Object)expected.bucket());
    }

    private TableSchema createTableSchema() throws Exception {
        return SchemaUtils.forceCommit((SchemaManager)new SchemaManager((FileIO)LocalFileIO.create(), new Path(this.tempDir.toString())), (Schema)new Schema(ROW_TYPE.getFields(), Arrays.asList("pt1", "pt2"), Arrays.asList("pt1", "pt2", "k1", "k2"), Collections.singletonMap("bucket", "1"), ""));
    }
}

