/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.paimon.flink.action.cdc.CdcActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mysql.MySqlContainer;
import org.apache.paimon.flink.action.cdc.mysql.MySqlSyncDatabaseAction;
import org.apache.paimon.flink.action.cdc.mysql.MySqlSyncTableAction;
import org.apache.paimon.flink.action.cdc.mysql.MySqlVersion;
import org.junit.jupiter.api.AfterAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;

public class MySqlActionITCaseBase
extends CdcActionITCaseBase {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlActionITCaseBase.class);
    protected static final MySqlContainer MYSQL_CONTAINER = MySqlActionITCaseBase.createMySqlContainer(MySqlVersion.V5_7);
    private static final String USER = "paimonuser";
    private static final String PASSWORD = "paimonpw";

    @AfterAll
    public static void stopContainers() {
        LOG.info("Stopping containers...");
        MYSQL_CONTAINER.stop();
        LOG.info("Containers are stopped.");
    }

    private static MySqlContainer createMySqlContainer(MySqlVersion version) {
        return (MySqlContainer)new MySqlContainer(version).withConfigurationOverride("mysql/my.cnf").withUsername(USER).withPassword(PASSWORD).withEnv("TZ", "America/Los_Angeles").withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    }

    protected static void start() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(MYSQL_CONTAINER)).join();
        LOG.info("Containers are started.");
    }

    protected Statement getStatement() throws SQLException {
        Connection conn = DriverManager.getConnection(MYSQL_CONTAINER.getJdbcUrl(), MYSQL_CONTAINER.getUsername(), MYSQL_CONTAINER.getPassword());
        return conn.createStatement();
    }

    protected Map<String, String> getBasicMySqlConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("hostname", MYSQL_CONTAINER.getHost());
        config.put("port", String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        config.put("username", USER);
        config.put("password", PASSWORD);
        config.put("server-time-zone", ZoneId.of("America/New_York").toString());
        config.put("scan.newly-added-table.enabled", "false");
        return config;
    }

    protected MySqlSyncTableActionBuilder syncTableActionBuilder(Map<String, String> mySqlConfig) {
        return new MySqlSyncTableActionBuilder(mySqlConfig);
    }

    protected MySqlSyncDatabaseActionBuilder syncDatabaseActionBuilder(Map<String, String> mySqlConfig) {
        return new MySqlSyncDatabaseActionBuilder(mySqlConfig);
    }

    protected class MySqlSyncDatabaseActionBuilder
    extends CdcActionITCaseBase.SyncDatabaseActionBuilder<MySqlSyncDatabaseAction> {
        public MySqlSyncDatabaseActionBuilder(Map<String, String> mySqlConfig) {
            super(MySqlSyncDatabaseAction.class, mySqlConfig);
        }
    }

    protected class MySqlSyncTableActionBuilder
    extends CdcActionITCaseBase.SyncTableActionBuilder<MySqlSyncTableAction> {
        public MySqlSyncTableActionBuilder(Map<String, String> mySqlConfig) {
            super(MySqlSyncTableAction.class, mySqlConfig);
        }
    }
}

