/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.kafka;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.action.cdc.kafka.KafkaSyncTableAction;
import org.apache.paimon.flink.action.cdc.kafka.KafkaSyncTableActionITCase;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class KafkaDebeziumSyncTableActionITCase
extends KafkaSyncTableActionITCase {
    private static final String DEBEZIUM = "debezium";

    @Test
    @Timeout(value=60L)
    public void testSchemaEvolution() throws Exception {
        this.runSingleTableSchemaEvolution("schemaevolution", DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testNotSupportFormat() throws Exception {
        this.testNotSupportFormat(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testAssertSchemaCompatible() throws Exception {
        this.testAssertSchemaCompatible(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testStarUpOptionSpecific() throws Exception {
        this.testStarUpOptionSpecific(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testStarUpOptionLatest() throws Exception {
        this.testStarUpOptionLatest(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testStarUpOptionTimestamp() throws Exception {
        this.testStarUpOptionTimestamp(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testStarUpOptionEarliest() throws Exception {
        this.testStarUpOptionEarliest(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testStarUpOptionGroup() throws Exception {
        this.testStarUpOptionGroup(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testComputedColumn() throws Exception {
        this.testComputedColumn(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testWaterMarkSyncTable() throws Exception {
        this.testWaterMarkSyncTable(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testKafkaBuildSchemaWithDelete() throws Exception {
        this.testKafkaBuildSchemaWithDelete(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testSchemaIncludeRecord() throws Exception {
        this.testSchemaIncludeRecord(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testSchemaEvolutionWithSchemaIncludeRecord() throws Exception {
        this.runSingleTableSchemaEvolutionWithSchemaIncludeRecord("schemaevolution", DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testAllTypesWithSchema() throws Exception {
        this.testAllTypesWithSchemaImpl(DEBEZIUM);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithNullValue() throws Exception {
        String topic = "test_null_value";
        this.createTestTopic("test_null_value", 1, 1);
        this.writeRecordsToKafka("test_null_value", "kafka/debezium/table/nullvalue/debezium-data-1.txt", new Object[0]);
        kafkaProducer.send(new ProducerRecord("test_null_value", null));
        this.writeRecordsToKafka("test_null_value", "kafka/debezium/table/nullvalue/debezium-data-2.txt", new Object[0]);
        Map<String, String> kafkaConfig = this.getBasicKafkaConfig();
        kafkaConfig.put(KafkaConnectorOptions.VALUE_FORMAT.key(), "debezium-json");
        kafkaConfig.put(KafkaConnectorOptions.TOPIC.key(), "test_null_value");
        KafkaSyncTableAction action = (KafkaSyncTableAction)this.syncTableActionBuilder(kafkaConfig).withPrimaryKeys("id").withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING()}, (String[])new String[]{"id", "value"});
        this.waitForResult(Arrays.asList("+I[1, A]", "+I[2, B]"), this.getFileStoreTable(this.tableName), rowType, Collections.singletonList("id"));
    }
}

