/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import javax.annotation.Nullable;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.cdc.CdcSinkBuilder;
import org.apache.paimon.flink.sink.cdc.RichCdcRecord;
import org.apache.paimon.flink.sink.cdc.RichEventParser;
import org.apache.paimon.table.Table;

@Public
public class RichCdcSinkBuilder {
    private DataStream<RichCdcRecord> input = null;
    private Table table = null;
    private Identifier identifier = null;
    private CatalogLoader catalogLoader = null;
    @Nullable
    private Integer parallelism;

    public RichCdcSinkBuilder(Table table) {
        this.table = table;
    }

    public RichCdcSinkBuilder forRichCdcRecord(DataStream<RichCdcRecord> input) {
        this.input = input;
        return this;
    }

    public RichCdcSinkBuilder identifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RichCdcSinkBuilder parallelism(@Nullable Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public RichCdcSinkBuilder catalogLoader(CatalogLoader catalogLoader) {
        this.catalogLoader = catalogLoader;
        return this;
    }

    public DataStreamSink<?> build() {
        CdcSinkBuilder builder = new CdcSinkBuilder();
        return builder.withTable(this.table).withInput(this.input).withParserFactory(RichEventParser::new).withParallelism(this.parallelism).withIdentifier(this.identifier).withCatalogLoader(this.catalogLoader).build();
    }

    @Deprecated
    public RichCdcSinkBuilder() {
    }

    @Deprecated
    public RichCdcSinkBuilder withInput(DataStream<RichCdcRecord> input) {
        this.input = input;
        return this;
    }

    @Deprecated
    public RichCdcSinkBuilder withTable(Table table) {
        this.table = table;
        return this;
    }

    @Deprecated
    public RichCdcSinkBuilder withParallelism(@Nullable Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Deprecated
    public RichCdcSinkBuilder withIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @Deprecated
    public RichCdcSinkBuilder withCatalogLoader(CatalogLoader catalogLoader) {
        this.catalogLoader = catalogLoader;
        return this;
    }
}

