/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.util.Map;
import org.apache.paimon.flink.action.cdc.SyncTableActionFactoryBase;
import org.apache.paimon.flink.action.cdc.mysql.MySqlSyncTableAction;

public class MySqlSyncTableActionFactory
extends SyncTableActionFactoryBase {
    public static final String IDENTIFIER = "mysql_sync_table";

    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public String cdcConfigIdentifier() {
        return "mysql_conf";
    }

    @Override
    public MySqlSyncTableAction createAction() {
        return new MySqlSyncTableAction(this.database, this.table, (Map<String, String>)this.catalogConfig, this.cdcSourceConfig);
    }

    public void printHelp() {
        System.out.println("Action \"mysql_sync_table\" creates a streaming job with a Flink MySQL CDC source and a Paimon table sink to consume CDC events.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  mysql_sync_table --warehouse <warehouse_path> --database <database_name> --table <table_name> [--partition_keys <partition_keys>] [--primary_keys <primary_keys>] [--type_mapping <option1,option2...>] [--computed_column <'column_name=expr_name(args[, ...])'> [--computed_column ...]] [--metadata_column <metadata_column>] [--mysql_conf <mysql_cdc_source_conf> [--mysql_conf <mysql_cdc_source_conf> ...]] [--catalog_conf <paimon_catalog_conf> [--catalog_conf <paimon_catalog_conf> ...]] [--table_conf <paimon_table_sink_conf> [--table_conf <paimon_table_sink_conf> ...]]");
        System.out.println();
        System.out.println("Partition keys syntax:");
        System.out.println("  key1,key2,...");
        System.out.println("If partition key is not defined and the specified Paimon table does not exist, this action will automatically create an unpartitioned Paimon table.");
        System.out.println();
        System.out.println("Primary keys syntax:");
        System.out.println("  key1,key2,...");
        System.out.println("Primary keys will be derived from MySQL tables if not specified.");
        System.out.println();
        System.out.println("--type_mapping is used to specify how to map MySQL type to Paimon type. Please see the doc for usage.");
        System.out.println();
        System.out.println("Please see doc for usage of --computed_column.");
        System.out.println();
        System.out.println("--metadata_column is used to specify which metadata columns to include in the output schema of the connector. Please see the doc for usage.");
        System.out.println();
        System.out.println("MySQL CDC source conf syntax:");
        System.out.println("  key=value");
        System.out.println("'hostname', 'username', 'password', 'database-name' and 'table-name' are required configurations, others are optional.");
        System.out.println("For a complete list of supported configurations, see https://nightlies.apache.org/flink/flink-cdc-docs-release-3.1/docs/connectors/flink-sources/mysql-cdc/#connector-options");
        System.out.println();
        System.out.println("Paimon catalog and table sink conf syntax:");
        System.out.println("  key=value");
        System.out.println("For a complete list of supported configurations, see https://paimon.apache.org/docs/master/maintenance/configurations/");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  mysql_sync_table \\\n    --warehouse hdfs:///path/to/warehouse \\\n    --database test_db \\\n    --table test_table \\\n    --partition_keys pt \\\n    --primary_keys pt,uid \\\n    --mysql_conf hostname=127.0.0.1 \\\n    --mysql_conf username=root \\\n    --mysql_conf password=123456 \\\n    --mysql_conf database-name=source_db \\\n    --mysql_conf table-name='source_table' \\\n    --catalog_conf metastore=hive \\\n    --catalog_conf uri=thrift://hive-metastore:9083 \\\n    --table_conf bucket=4 \\\n    --table_conf changelog-producer=input \\\n    --table_conf sink.parallelism=4");
    }
}

