/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.aliyun;

public class AliyunFieldParser {
    protected static byte[] convertGeoType2WkbArray(byte[] mysqlGeomBytes) {
        byte[] wkb;
        int sridLength = 4;
        boolean hasSrid = false;
        for (int i = 0; i < sridLength; ++i) {
            if (mysqlGeomBytes[i] == 0) continue;
            hasSrid = true;
            break;
        }
        if (hasSrid) {
            wkb = new byte[mysqlGeomBytes.length];
            System.arraycopy(mysqlGeomBytes, 4, wkb, 0, 5);
            System.arraycopy(mysqlGeomBytes, 0, wkb, 5, 4);
            System.arraycopy(mysqlGeomBytes, 9, wkb, 9, wkb.length - 9);
            if (wkb[0] == 0) {
                wkb[1] = (byte)(wkb[1] + 32);
            } else {
                wkb[4] = (byte)(wkb[4] + 32);
            }
        } else {
            wkb = new byte[mysqlGeomBytes.length - 4];
            System.arraycopy(mysqlGeomBytes, 4, wkb, 0, wkb.length);
        }
        return wkb;
    }

    protected static String convertSet(String value, String mysqlType) {
        int indexes = Integer.parseInt(value);
        return AliyunFieldParser.getSetValuesByIndex(mysqlType, indexes);
    }

    protected static String convertEnum(String value, String mysqlType) {
        int elementIndex = Integer.parseInt(value);
        return AliyunFieldParser.getEnumValueByIndex(mysqlType, elementIndex);
    }

    protected static String getEnumValueByIndex(String mysqlType, int elementIndex) {
        String[] options = AliyunFieldParser.extractEnumValueByIndex(mysqlType);
        return options[elementIndex - 1];
    }

    protected static String getSetValuesByIndex(String mysqlType, int indexes) {
        String[] options = AliyunFieldParser.extractSetValuesByIndex(mysqlType);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int index = 0;
        boolean first = true;
        int optionLen = options.length;
        while ((long)indexes != 0L) {
            if ((long)indexes % 2L != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (index < optionLen) {
                    sb.append(options[index]);
                } else {
                    throw new RuntimeException(String.format("extractSetValues from mysqlType[%s],index:%d failed", mysqlType, indexes));
                }
            }
            ++index;
            indexes >>>= 1;
        }
        sb.append("]");
        return sb.toString();
    }

    private static String[] extractSetValuesByIndex(String mysqlType) {
        return mysqlType.substring(5, mysqlType.length() - 2).split("'\\s*,\\s*'");
    }

    private static String[] extractEnumValueByIndex(String mysqlType) {
        return mysqlType.substring(6, mysqlType.length() - 2).split("'\\s*,\\s*'");
    }
}

