/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.utils.StringUtils;

public class TableNameConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean caseSensitive;
    private final boolean mergeShards;
    private final Map<String, String> dbPrefix;
    private final Map<String, String> dbSuffix;
    private final String prefix;
    private final String suffix;
    private final Map<String, String> tableMapping;

    public TableNameConverter(boolean caseSensitive) {
        this(caseSensitive, true, "", "", null);
    }

    public TableNameConverter(boolean caseSensitive, boolean mergeShards, String prefix, String suffix, Map<String, String> tableMapping) {
        this(caseSensitive, mergeShards, new HashMap<String, String>(), new HashMap<String, String>(), prefix, suffix, tableMapping);
    }

    public TableNameConverter(boolean caseSensitive, boolean mergeShards, Map<String, String> dbPrefix, Map<String, String> dbSuffix, String prefix, String suffix, Map<String, String> tableMapping) {
        this.caseSensitive = caseSensitive;
        this.mergeShards = mergeShards;
        this.dbPrefix = dbPrefix;
        this.dbSuffix = dbSuffix;
        this.prefix = prefix;
        this.suffix = suffix;
        this.tableMapping = this.lowerMapKey(tableMapping);
    }

    public String convert(String originDbName, String originTblName) {
        if (this.tableMapping.containsKey(originTblName.toLowerCase())) {
            String mappedName = this.tableMapping.get(originTblName.toLowerCase());
            return StringUtils.toLowerCaseIfNeed((String)mappedName, (boolean)this.caseSensitive);
        }
        String tblPrefix = this.prefix;
        String tblSuffix = this.suffix;
        if (this.dbPrefix.containsKey(originDbName.toLowerCase())) {
            tblPrefix = this.dbPrefix.get(originDbName.toLowerCase());
        }
        if (this.dbSuffix.containsKey(originDbName.toLowerCase())) {
            tblSuffix = this.dbSuffix.get(originDbName.toLowerCase());
        }
        String tableName = StringUtils.toLowerCaseIfNeed((String)originTblName, (boolean)this.caseSensitive);
        return tblPrefix + tableName + tblSuffix;
    }

    public String convert(Identifier originIdentifier) {
        String rawName = this.mergeShards ? originIdentifier.getObjectName() : originIdentifier.getDatabaseName() + "_" + originIdentifier.getObjectName();
        return this.convert(originIdentifier.getDatabaseName(), rawName);
    }

    private Map<String, String> lowerMapKey(Map<String, String> map) {
        int size = map == null ? 0 : map.size();
        HashMap<String, String> lowerKeyMap = new HashMap<String, String>(size);
        if (size == 0) {
            return lowerKeyMap;
        }
        for (String key : map.keySet()) {
            lowerKeyMap.put(key.toLowerCase(), map.get(key));
        }
        return lowerKeyMap;
    }
}

