/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import java.util.HashSet;
import java.util.Set;
import org.apache.paimon.flink.action.cdc.mysql.MySqlVersion;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.DockerImageName;

public class MySqlContainer
extends JdbcDatabaseContainer {
    public static final String IMAGE = "mysql";
    public static final Integer MYSQL_PORT = 3306;
    private static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "MY_CNF";
    private static final String SETUP_SQL_PARAM_NAME = "SETUP_SQL";
    private static final String MYSQL_ROOT_USER = "root";
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";

    public MySqlContainer(MySqlVersion version) {
        super(DockerImageName.parse((String)("mysql:" + version.getVersion())));
        this.addExposedPort(MYSQL_PORT);
    }

    protected Set<Integer> getLivenessCheckPorts() {
        return new HashSet<Integer>(this.getMappedPort(MYSQL_PORT));
    }

    protected void configure() {
        this.optionallyMapResourceParameterAsVolume(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, "/etc/mysql/", "mysql-default-conf");
        if (this.parameters.containsKey(SETUP_SQL_PARAM_NAME)) {
            this.optionallyMapResourceParameterAsVolume(SETUP_SQL_PARAM_NAME, "/docker-entrypoint-initdb.d/", "N/A");
        }
        this.addEnv("MYSQL_DATABASE", this.databaseName);
        this.addEnv("MYSQL_USER", this.username);
        if (this.password != null && !this.password.isEmpty()) {
            this.addEnv("MYSQL_PASSWORD", this.password);
            this.addEnv("MYSQL_ROOT_PASSWORD", this.password);
        } else if (MYSQL_ROOT_USER.equalsIgnoreCase(this.username)) {
            this.addEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "yes");
        } else {
            throw new ContainerLaunchException("Empty password can be used only with the root user");
        }
        this.setStartupAttempts(3);
    }

    public String getDriverClassName() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            return "com.mysql.cj.jdbc.Driver";
        }
        catch (ClassNotFoundException e) {
            return "com.mysql.jdbc.Driver";
        }
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:mysql://" + this.getHost() + ":" + this.getDatabasePort() + additionalUrlParams;
    }

    public int getDatabasePort() {
        return this.getMappedPort(MYSQL_PORT);
    }

    protected String constructUrlForConnection(String queryString) {
        String url = super.constructUrlForConnection(queryString);
        if (!url.contains("useSSL=")) {
            String separator = url.contains("?") ? "&" : "?";
            url = url + separator + "useSSL=false";
        }
        if (!url.contains("allowPublicKeyRetrieval=")) {
            url = url + "&allowPublicKeyRetrieval=true";
        }
        return url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected String getTestQueryString() {
        return "SELECT 1";
    }

    public MySqlContainer withConfigurationOverride(String s) {
        this.parameters.put(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, s);
        return this;
    }

    public MySqlContainer withSetupSQL(String sqlPath) {
        this.parameters.put(SETUP_SQL_PARAM_NAME, sqlPath);
        return this;
    }

    public MySqlContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public MySqlContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public MySqlContainer withPassword(String password) {
        this.password = password;
        return this;
    }
}

