/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongodbSchemaUtils;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.bson.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class MongodbSchemaITCase
extends MongoDBActionITCaseBase {
    @BeforeAll
    public static void initMongoDB() {
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(new ServerAddress(MONGODB_CONTAINER.getHostAndPort())))).credential(MongoCredential.createCredential((String)"flinkuser", (String)"admin", (char[])"a1?~!@#$%^&*(){}[]<>.,+_-=/|:;".toCharArray()));
        MongoClientSettings settings = settingsBuilder.build();
        try (MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);){
            MongoDatabase database = mongoClient.getDatabase("testDatabase");
            MongoCollection collection = database.getCollection("testCollection");
            Document doc = new Document("name", (Object)"Alice").append("age", (Object)30);
            collection.insertOne((Object)doc);
        }
    }

    @Test
    public void testCreateSchemaFromValidConfig() {
        Configuration mongodbConfig = new Configuration();
        mongodbConfig.setString(MongoDBSourceOptions.HOSTS, MONGODB_CONTAINER.getHostAndPort());
        mongodbConfig.setString(MongoDBSourceOptions.USERNAME, "flinkuser");
        mongodbConfig.setString(MongoDBSourceOptions.PASSWORD, "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;");
        mongodbConfig.setString(MongoDBSourceOptions.CONNECTION_OPTIONS, "authSource=admin");
        mongodbConfig.setString(MongoDBSourceOptions.DATABASE, "testDatabase");
        mongodbConfig.setString(MongoDBSourceOptions.COLLECTION, "testCollection");
        Schema schema = MongodbSchemaUtils.getMongodbSchema((Configuration)mongodbConfig);
        Assertions.assertNotNull((Object)schema);
    }

    @Test
    public void testCreateSchemaFromInvalidHost() {
        Configuration mongodbConfig = new Configuration();
        mongodbConfig.setString(MongoDBSourceOptions.HOSTS, "127.0.0.1:12345");
        mongodbConfig.setString(MongoDBSourceOptions.USERNAME, "flinkuser");
        mongodbConfig.setString(MongoDBSourceOptions.PASSWORD, "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;");
        mongodbConfig.setString(MongoDBSourceOptions.CONNECTION_OPTIONS, "authSource=admin");
        mongodbConfig.setString(MongoDBSourceOptions.DATABASE, "testDatabase");
        mongodbConfig.setString(MongoDBSourceOptions.COLLECTION, "testCollection");
        Assertions.assertThrows(RuntimeException.class, () -> MongodbSchemaUtils.getMongodbSchema((Configuration)mongodbConfig));
    }

    @Test
    public void testCreateSchemaFromIncompleteConfig() {
        Configuration mongodbConfig = new Configuration();
        mongodbConfig.setString(MongoDBSourceOptions.HOSTS, MONGODB_CONTAINER.getHostAndPort());
        Assertions.assertThrows(NullPointerException.class, () -> MongodbSchemaUtils.getMongodbSchema((Configuration)mongodbConfig));
    }

    @Test
    public void testCreateSchemaFromDynamicConfig() {
        Configuration mongodbConfig = new Configuration();
        mongodbConfig.setString(MongoDBSourceOptions.HOSTS, MONGODB_CONTAINER.getHostAndPort());
        mongodbConfig.setString(MongoDBSourceOptions.USERNAME, "flinkuser");
        mongodbConfig.setString(MongoDBSourceOptions.PASSWORD, "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;");
        mongodbConfig.setString(MongoDBSourceOptions.CONNECTION_OPTIONS, "authSource=admin");
        mongodbConfig.setString(MongoDBSourceOptions.DATABASE, "testDatabase");
        mongodbConfig.setString(MongoDBSourceOptions.COLLECTION, "testCollection");
        Schema schema = MongodbSchemaUtils.getMongodbSchema((Configuration)mongodbConfig);
        Assertions.assertNotNull((Object)schema);
        ArrayList<DataField> expectedFields = new ArrayList<DataField>();
        expectedFields.add(new DataField(0, "_id", DataTypes.STRING().notNull()));
        expectedFields.add(new DataField(1, "name", (DataType)DataTypes.STRING()));
        expectedFields.add(new DataField(2, "age", (DataType)DataTypes.STRING()));
        Assertions.assertEquals(expectedFields, (Object)schema.fields());
    }

    @Test
    public void testCreateSchemaFromInvalidDatabase() {
        Configuration mongodbConfig = new Configuration();
        mongodbConfig.setString(MongoDBSourceOptions.HOSTS, MONGODB_CONTAINER.getHostAndPort());
        mongodbConfig.setString(MongoDBSourceOptions.USERNAME, "flinkuser");
        mongodbConfig.setString(MongoDBSourceOptions.PASSWORD, "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;");
        mongodbConfig.setString(MongoDBSourceOptions.CONNECTION_OPTIONS, "authSource=admin");
        mongodbConfig.setString(MongoDBSourceOptions.DATABASE, "invalidDatabase");
        mongodbConfig.setString(MongoDBSourceOptions.COLLECTION, "testCollection");
        Assertions.assertThrows(RuntimeException.class, () -> MongodbSchemaUtils.getMongodbSchema((Configuration)mongodbConfig));
    }

    @Test
    public void testCreateSchemaFromInvalidCollection() {
        Configuration mongodbConfig = new Configuration();
        mongodbConfig.setString(MongoDBSourceOptions.HOSTS, MONGODB_CONTAINER.getHostAndPort());
        mongodbConfig.setString(MongoDBSourceOptions.USERNAME, "flinkuser");
        mongodbConfig.setString(MongoDBSourceOptions.PASSWORD, "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;");
        mongodbConfig.setString(MongoDBSourceOptions.CONNECTION_OPTIONS, "authSource=admin");
        mongodbConfig.setString(MongoDBSourceOptions.DATABASE, "testDatabase");
        mongodbConfig.setString(MongoDBSourceOptions.COLLECTION, "invalidCollection");
        Assertions.assertThrows(RuntimeException.class, () -> MongodbSchemaUtils.getMongodbSchema((Configuration)mongodbConfig));
    }
}

