/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@Public
public final class RowType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "ROW<%s>";
    private final List<DataField> fields;
    private InternalRow.FieldGetter[] fieldGetters;

    public RowType(boolean isNullable, List<DataField> fields) {
        super(isNullable, DataTypeRoot.ROW);
        this.fields = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(fields, "Fields must not be null.")));
        RowType.validateFields(fields);
    }

    public RowType(List<DataField> fields) {
        this(true, fields);
    }

    public List<DataField> getFields() {
        return this.fields;
    }

    public List<String> getFieldNames() {
        return this.fields.stream().map(DataField::name).collect(Collectors.toList());
    }

    public List<DataType> getFieldTypes() {
        return this.fields.stream().map(DataField::type).collect(Collectors.toList());
    }

    public DataType getTypeAt(int i) {
        return this.fields.get(i).type();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).name().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new RowType(isNullable, this.fields.stream().map(DataField::copy).collect(Collectors.toList()));
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.fields.stream().map(DataField::asSQLString).collect(Collectors.joining(", ")));
    }

    @Override
    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", this.isNullable() ? "ROW" : "ROW NOT NULL");
        generator.writeArrayFieldStart("fields");
        for (DataField field : this.getFields()) {
            field.serializeJson(generator);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType rowType = (RowType)o;
        return this.fields.equals(rowType.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }

    private static void validateFields(List<DataField> fields) {
        List fieldNames = fields.stream().map(DataField::name).collect(Collectors.toList());
        if (fieldNames.stream().anyMatch(StringUtils::isNullOrWhitespaceOnly)) {
            throw new IllegalArgumentException("Field names must contain at least one non-whitespace character.");
        }
        Set duplicates = fieldNames.stream().filter(n -> Collections.frequency(fieldNames, n) > 1).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field names must be unique. Found duplicates: %s", duplicates));
        }
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void collectFieldIds(Set<Integer> fieldIds) {
        for (DataField field : this.fields) {
            if (fieldIds.contains(field.id())) {
                throw new RuntimeException(String.format("Broken schema, field id %s is duplicated.", field.id()));
            }
            fieldIds.add(field.id());
            field.type().collectFieldIds(fieldIds);
        }
    }

    public RowType appendDataField(String name, DataType type) {
        ArrayList<DataField> newFields = new ArrayList<DataField>(this.fields);
        int newId = RowType.currentHighestFieldId(this.fields) + 1;
        newFields.add(new DataField(newId, name, type));
        return new RowType(newFields);
    }

    public static RowType of(DataType ... types) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new DataField(i, "f" + i, types[i]));
        }
        return new RowType(true, fields);
    }

    public static RowType of(DataType[] types, String[] names) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new DataField(i, names[i], types[i]));
        }
        return new RowType(true, fields);
    }

    public static int currentHighestFieldId(List<DataField> fields) {
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        new RowType(fields).collectFieldIds(fieldIds);
        return fieldIds.stream().max(Integer::compareTo).orElse(-1);
    }

    public static Builder builder() {
        return RowType.builder(true, new AtomicInteger(-1));
    }

    public static Builder builder(boolean isNullable, AtomicInteger fieldId) {
        return new Builder(isNullable, fieldId);
    }

    public InternalRow.FieldGetter[] fieldGetters() {
        if (this.fieldGetters == null) {
            this.fieldGetters = (InternalRow.FieldGetter[])IntStream.range(0, this.getFieldCount()).mapToObj(i -> InternalRow.createFieldGetter(this.getTypeAt(i), i)).toArray(InternalRow.FieldGetter[]::new);
        }
        return this.fieldGetters;
    }

    public static class Builder {
        private final List<DataField> fields = new ArrayList<DataField>();
        private final boolean isNullable;
        private final AtomicInteger fieldId;

        private Builder(boolean isNullable, AtomicInteger fieldId) {
            this.isNullable = isNullable;
            this.fieldId = fieldId;
        }

        public Builder field(String name, DataType type) {
            this.fields.add(new DataField(this.fieldId.incrementAndGet(), name, type));
            return this;
        }

        public Builder field(String name, DataType type, String description) {
            this.fields.add(new DataField(this.fieldId.incrementAndGet(), name, type, description));
            return this;
        }

        public Builder fields(List<DataType> types) {
            for (int i = 0; i < types.size(); ++i) {
                this.field("f" + i, types.get(i));
            }
            return this;
        }

        public Builder fields(DataType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.field("f" + i, types[i]);
            }
            return this;
        }

        public Builder fields(DataType[] types, String[] names) {
            for (int i = 0; i < types.length; ++i) {
                this.field(names[i], types[i]);
            }
            return this;
        }

        public RowType build() {
            return new RowType(this.isNullable, this.fields);
        }
    }
}

