/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.hash;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.io.cache.FileBasedRandomInputView;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.utils.FileBasedBloomFilter;
import org.apache.paimon.utils.MurmurHashUtils;
import org.apache.paimon.utils.VarLengthIntUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashLookupStoreReader
implements LookupStoreReader,
Iterable<Map.Entry<byte[], byte[]>> {
    private static final Logger LOG = LoggerFactory.getLogger((String)HashLookupStoreReader.class.getName());
    private final int[] keyCounts;
    private final int[] slotSizes;
    private final int[] slots;
    private final int[] indexOffsets;
    private final long[] dataOffsets;
    private FileBasedRandomInputView inputView;
    private final byte[] slotBuffer;
    @Nullable
    private FileBasedBloomFilter bloomFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashLookupStoreReader(CacheManager cacheManager, int cachePageSize, File file) throws IOException {
        long dataOffset;
        int indexOffset;
        boolean bloomFilterEnabled;
        int keyCount;
        long createdAt;
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        LOG.info("Opening file {}", (Object)file.getName());
        this.inputView = new FileBasedRandomInputView(file, cacheManager, cachePageSize);
        FileInputStream inputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            int i;
            createdAt = dataInputStream.readLong();
            keyCount = dataInputStream.readInt();
            int keyLengthCount = dataInputStream.readInt();
            int maxKeyLength = dataInputStream.readInt();
            bloomFilterEnabled = dataInputStream.readBoolean();
            if (bloomFilterEnabled) {
                long recordCount = dataInputStream.readLong();
                int bfBytes = dataInputStream.readInt();
                int bfStartIndex = dataInputStream.readInt();
                dataInputStream.skipBytes(bfBytes);
                this.bloomFilter = new FileBasedBloomFilter(this.inputView.file(), cacheManager, recordCount, bfStartIndex, bfBytes);
            }
            this.indexOffsets = new int[maxKeyLength + 1];
            this.dataOffsets = new long[maxKeyLength + 1];
            this.keyCounts = new int[maxKeyLength + 1];
            this.slots = new int[maxKeyLength + 1];
            this.slotSizes = new int[maxKeyLength + 1];
            int maxSlotSize = 0;
            for (i = 0; i < keyLengthCount; ++i) {
                int keyLength = dataInputStream.readInt();
                this.keyCounts[keyLength] = dataInputStream.readInt();
                this.slots[keyLength] = dataInputStream.readInt();
                this.slotSizes[keyLength] = dataInputStream.readInt();
                this.indexOffsets[keyLength] = dataInputStream.readInt();
                this.dataOffsets[keyLength] = dataInputStream.readLong();
                maxSlotSize = Math.max(maxSlotSize, this.slotSizes[keyLength]);
            }
            this.slotBuffer = new byte[maxSlotSize];
            indexOffset = dataInputStream.readInt();
            for (i = 0; i < this.indexOffsets.length; ++i) {
                this.indexOffsets[i] = indexOffset + this.indexOffsets[i];
            }
            dataOffset = dataInputStream.readLong();
            for (i = 0; i < this.dataOffsets.length; ++i) {
                this.dataOffsets[i] = dataOffset + this.dataOffsets[i];
            }
        }
        finally {
            dataInputStream.close();
            inputStream.close();
        }
        DecimalFormat integerFormat = new DecimalFormat("#,##0.00");
        StringBuilder statMsg = new StringBuilder("Storage metadata\n");
        statMsg.append("  Created at: ").append(this.formatCreatedAt(createdAt)).append("\n");
        statMsg.append("  Key count: ").append(keyCount).append("\n");
        statMsg.append("  Bloom filter: ").append(bloomFilterEnabled).append("\n");
        for (int i = 0; i < this.keyCounts.length; ++i) {
            if (this.keyCounts[i] <= 0) continue;
            statMsg.append("  Key count for key length ").append(i).append(": ").append(this.keyCounts[i]).append("\n");
        }
        statMsg.append("  Index size: ").append(integerFormat.format((double)(dataOffset - (long)indexOffset) / 1048576.0)).append(" Mb\n");
        statMsg.append("  Data size: ").append(integerFormat.format((double)(file.length() - dataOffset) / 1048576.0)).append(" Mb\n");
        LOG.info(statMsg.toString());
    }

    @Override
    public byte[] lookup(byte[] key) throws IOException {
        int keyLength = key.length;
        if (keyLength >= this.slots.length || this.keyCounts[keyLength] == 0) {
            return null;
        }
        int hashcode = MurmurHashUtils.hashBytes(key);
        if (this.bloomFilter != null && !this.bloomFilter.testHash(hashcode)) {
            return null;
        }
        long hashPositive = hashcode & Integer.MAX_VALUE;
        int numSlots = this.slots[keyLength];
        int slotSize = this.slotSizes[keyLength];
        int indexOffset = this.indexOffsets[keyLength];
        long dataOffset = this.dataOffsets[keyLength];
        for (int probe = 0; probe < numSlots; ++probe) {
            long slot = (hashPositive + (long)probe) % (long)numSlots;
            this.inputView.setReadPosition((long)indexOffset + slot * (long)slotSize);
            this.inputView.readFully(this.slotBuffer, 0, slotSize);
            long offset = VarLengthIntUtils.decodeLong(this.slotBuffer, keyLength);
            if (offset == 0L) {
                return null;
            }
            if (!this.isKey(this.slotBuffer, key)) continue;
            return this.getValue(dataOffset + offset);
        }
        return null;
    }

    private boolean isKey(byte[] slotBuffer, byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            if (slotBuffer[i] == key[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] getValue(long offset) throws IOException {
        this.inputView.setReadPosition(offset);
        int size = VarLengthIntUtils.decodeInt(this.inputView);
        byte[] res = new byte[size];
        this.inputView.readFully(res);
        return res;
    }

    private String formatCreatedAt(long createdAt) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z");
        Calendar cl = Calendar.getInstance();
        cl.setTimeInMillis(createdAt);
        return sdf.format(cl.getTime());
    }

    @Override
    public void close() throws IOException {
        this.inputView.close();
        this.inputView = null;
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return new StorageIterator(true);
    }

    public Iterator<Map.Entry<byte[], byte[]>> keys() {
        return new StorageIterator(false);
    }

    private class StorageIterator
    implements Iterator<Map.Entry<byte[], byte[]>> {
        private final FastEntry entry = new FastEntry();
        private final boolean withValue;
        private int currentKeyLength = 0;
        private byte[] currentSlotBuffer;
        private long keyIndex;
        private long keyLimit;
        private long currentDataOffset;
        private int currentIndexOffset;

        public StorageIterator(boolean value) {
            this.withValue = value;
            this.nextKeyLength();
        }

        private void nextKeyLength() {
            for (int i = this.currentKeyLength + 1; i < HashLookupStoreReader.this.keyCounts.length; ++i) {
                long c = HashLookupStoreReader.this.keyCounts[i];
                if (c <= 0L) continue;
                this.currentKeyLength = i;
                this.keyLimit += c;
                this.currentSlotBuffer = new byte[HashLookupStoreReader.this.slotSizes[i]];
                this.currentIndexOffset = HashLookupStoreReader.this.indexOffsets[i];
                this.currentDataOffset = HashLookupStoreReader.this.dataOffsets[i];
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.keyIndex < this.keyLimit;
        }

        @Override
        public FastEntry next() {
            try {
                HashLookupStoreReader.this.inputView.setReadPosition(this.currentIndexOffset);
                long offset = 0L;
                while (offset == 0L) {
                    HashLookupStoreReader.this.inputView.readFully(this.currentSlotBuffer);
                    offset = VarLengthIntUtils.decodeLong(this.currentSlotBuffer, this.currentKeyLength);
                    this.currentIndexOffset += this.currentSlotBuffer.length;
                }
                byte[] key = Arrays.copyOf(this.currentSlotBuffer, this.currentKeyLength);
                byte[] value = null;
                if (this.withValue) {
                    long valueOffset = this.currentDataOffset + offset;
                    value = HashLookupStoreReader.this.getValue(valueOffset);
                }
                this.entry.set(key, value);
                if (++this.keyIndex == this.keyLimit) {
                    this.nextKeyLength();
                }
                return this.entry;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private class FastEntry
        implements Map.Entry<byte[], byte[]> {
            private byte[] key;
            private byte[] val;

            private FastEntry() {
            }

            protected void set(byte[] k, byte[] v) {
                this.key = k;
                this.val = v;
            }

            @Override
            public byte[] getKey() {
                return this.key;
            }

            @Override
            public byte[] getValue() {
                return this.val;
            }

            @Override
            public byte[] setValue(byte[] value) {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
    }
}

