/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar;

import java.io.Serializable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataSetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.types.RowKind;

public final class ColumnarRow
implements InternalRow,
DataSetters,
Serializable {
    private static final long serialVersionUID = 1L;
    private RowKind rowKind = RowKind.INSERT;
    private VectorizedColumnBatch vectorizedColumnBatch;
    private int rowId;

    public ColumnarRow() {
    }

    public ColumnarRow(VectorizedColumnBatch vectorizedColumnBatch) {
        this(vectorizedColumnBatch, 0);
    }

    public ColumnarRow(VectorizedColumnBatch vectorizedColumnBatch, int rowId) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = rowId;
    }

    public void setVectorizedColumnBatch(VectorizedColumnBatch vectorizedColumnBatch) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = 0;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    @Override
    public RowKind getRowKind() {
        return this.rowKind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.rowKind = kind;
    }

    @Override
    public int getFieldCount() {
        return this.vectorizedColumnBatch.getArity();
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.vectorizedColumnBatch.isNullAt(this.rowId, pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.vectorizedColumnBatch.getBoolean(this.rowId, pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.vectorizedColumnBatch.getByte(this.rowId, pos);
    }

    @Override
    public short getShort(int pos) {
        return this.vectorizedColumnBatch.getShort(this.rowId, pos);
    }

    @Override
    public int getInt(int pos) {
        return this.vectorizedColumnBatch.getInt(this.rowId, pos);
    }

    @Override
    public long getLong(int pos) {
        return this.vectorizedColumnBatch.getLong(this.rowId, pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.vectorizedColumnBatch.getFloat(this.rowId, pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.vectorizedColumnBatch.getDouble(this.rowId, pos);
    }

    @Override
    public BinaryString getString(int pos) {
        BytesColumnVector.Bytes byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, pos);
        return BinaryString.fromBytes(byteArray.data, byteArray.offset, byteArray.len);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.vectorizedColumnBatch.getDecimal(this.rowId, pos, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return this.vectorizedColumnBatch.getTimestamp(this.rowId, pos, precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        BytesColumnVector.Bytes byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, pos);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        byte[] ret = new byte[byteArray.len];
        System.arraycopy(byteArray.data, byteArray.offset, ret, 0, byteArray.len);
        return ret;
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return this.vectorizedColumnBatch.getRow(this.rowId, pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        return this.vectorizedColumnBatch.getArray(this.rowId, pos);
    }

    @Override
    public InternalMap getMap(int pos) {
        return this.vectorizedColumnBatch.getMap(this.rowId, pos);
    }

    @Override
    public void setNullAt(int pos) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setByte(int pos, byte value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setShort(int pos, short value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setInt(int pos, int value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setLong(int pos, long value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setFloat(int pos, float value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDouble(int pos, double value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setTimestamp(int pos, Timestamp value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("ColumnarRowData do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ColumnarRowData do not support hashCode, please hash fields one by one!");
    }

    VectorizedColumnBatch vectorizedColumnBatch() {
        return this.vectorizedColumnBatch;
    }

    public ColumnarRow copy(ColumnVector[] vectors) {
        VectorizedColumnBatch vectorizedColumnBatchCopy = this.vectorizedColumnBatch.copy(vectors);
        ColumnarRow columnarRow = new ColumnarRow(vectorizedColumnBatchCopy, this.rowId);
        columnarRow.setRowKind(this.rowKind);
        return columnarRow;
    }
}

