/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.paimon.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    private static final int BLOCKSIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, int buffSize, boolean close) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                bytesRead = in.read(buf);
            }
        }
        finally {
            if (close) {
                out.close();
                in.close();
            }
        }
    }

    public static void copyBytes(InputStream in, OutputStream out) throws IOException {
        IOUtils.copyBytes(in, out, 4096, true);
    }

    public static void readFully(InputStream in, byte[] buf) throws IOException {
        IOUtils.readFully(in, buf, 0, buf.length);
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        IOUtils.closeAll(Arrays.asList(closeables));
    }

    public static void closeAll(Iterable<? extends AutoCloseable> closeables) throws Exception {
        IOUtils.closeAll(closeables, Exception.class);
    }

    public static <T extends Throwable> void closeAll(Iterable<? extends AutoCloseable> closeables, Class<T> suppressedException) throws Exception {
        if (null != closeables) {
            Exception collectedExceptions = null;
            for (AutoCloseable autoCloseable : closeables) {
                try {
                    if (null == autoCloseable) continue;
                    autoCloseable.close();
                }
                catch (Throwable e) {
                    if (!suppressedException.isAssignableFrom(e.getClass())) {
                        throw e;
                    }
                    Exception ex = e instanceof Exception ? (Exception)e : new Exception(e);
                    collectedExceptions = ExceptionUtils.firstOrSuppressed(ex, collectedExceptions);
                }
            }
            if (null != collectedExceptions) {
                throw collectedExceptions;
            }
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable e) {
            LOG.debug("Exception occurs when closing " + closeable, e);
        }
    }
}

