/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.ArrayColumnVector;
import org.apache.paimon.data.columnar.BooleanColumnVector;
import org.apache.paimon.data.columnar.ByteColumnVector;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.DecimalColumnVector;
import org.apache.paimon.data.columnar.DoubleColumnVector;
import org.apache.paimon.data.columnar.FloatColumnVector;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.MapColumnVector;
import org.apache.paimon.data.columnar.RowColumnVector;
import org.apache.paimon.data.columnar.ShortColumnVector;
import org.apache.paimon.data.columnar.TimestampColumnVector;

public class VectorizedColumnBatch
implements Serializable {
    private static final long serialVersionUID = 8180323238728166155L;
    public static final int DEFAULT_SIZE = 2048;
    private int numRows;
    public final ColumnVector[] columns;

    public VectorizedColumnBatch(ColumnVector[] vectors) {
        this.columns = vectors;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getArity() {
        return this.columns.length;
    }

    public boolean isNullAt(int rowId, int colId) {
        return this.columns[colId].isNullAt(rowId);
    }

    public boolean getBoolean(int rowId, int colId) {
        return ((BooleanColumnVector)this.columns[colId]).getBoolean(rowId);
    }

    public byte getByte(int rowId, int colId) {
        return ((ByteColumnVector)this.columns[colId]).getByte(rowId);
    }

    public short getShort(int rowId, int colId) {
        return ((ShortColumnVector)this.columns[colId]).getShort(rowId);
    }

    public int getInt(int rowId, int colId) {
        return ((IntColumnVector)this.columns[colId]).getInt(rowId);
    }

    public long getLong(int rowId, int colId) {
        return ((LongColumnVector)this.columns[colId]).getLong(rowId);
    }

    public float getFloat(int rowId, int colId) {
        return ((FloatColumnVector)this.columns[colId]).getFloat(rowId);
    }

    public double getDouble(int rowId, int colId) {
        return ((DoubleColumnVector)this.columns[colId]).getDouble(rowId);
    }

    public BytesColumnVector.Bytes getByteArray(int rowId, int colId) {
        return ((BytesColumnVector)this.columns[colId]).getBytes(rowId);
    }

    private byte[] getBytes(int rowId, int colId) {
        BytesColumnVector.Bytes byteArray = this.getByteArray(rowId, colId);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        return byteArray.getBytes();
    }

    public String getString(int rowId, int colId) {
        BytesColumnVector.Bytes byteArray = this.getByteArray(rowId, colId);
        return new String(byteArray.data, byteArray.offset, byteArray.len, StandardCharsets.UTF_8);
    }

    public Decimal getDecimal(int rowId, int colId, int precision, int scale) {
        return ((DecimalColumnVector)this.columns[colId]).getDecimal(rowId, precision, scale);
    }

    public Timestamp getTimestamp(int rowId, int colId, int precision) {
        return ((TimestampColumnVector)this.columns[colId]).getTimestamp(rowId, precision);
    }

    public InternalArray getArray(int rowId, int colId) {
        return ((ArrayColumnVector)this.columns[colId]).getArray(rowId);
    }

    public InternalRow getRow(int rowId, int colId) {
        return ((RowColumnVector)this.columns[colId]).getRow(rowId);
    }

    public InternalMap getMap(int rowId, int colId) {
        return ((MapColumnVector)this.columns[colId]).getMap(rowId);
    }
}

