/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tools.ci.utils.notice;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.tools.ci.utils.notice.NoticeContents;
import org.apache.paimon.tools.ci.utils.shared.Dependency;

public class NoticeParser {
    private static final Pattern NOTICE_DEPENDENCY_PATTERN = Pattern.compile("- (?<groupId>[^ ]*?):(?<artifactId>[^ ]*?):(?:(?<classifier>[^ ]*?):)?(?<version>[^ ]*?)($| )");
    private static final Pattern NOTICE_BUNDLES_DEPENDENCY_PATTERN = Pattern.compile(".*bundles \"(?<groupId>[^ ]*?):(?<artifactId>[^ ]*?):(?:(?<classifier>[^ ]*?):)?(?<version>[^ ]*?)\".*");

    public static Optional<NoticeContents> parseNoticeFile(Path noticeFile) throws IOException {
        List<String> noticeContents = Files.readAllLines(noticeFile);
        return NoticeParser.parseNoticeFile(noticeContents);
    }

    static Optional<NoticeContents> parseNoticeFile(List<String> noticeContents) {
        if (noticeContents.isEmpty()) {
            return Optional.empty();
        }
        String noticeModuleName = noticeContents.get(0);
        ArrayList<Dependency> declaredDependencies = new ArrayList<Dependency>();
        for (String line : noticeContents) {
            Optional<Dependency> dependency = NoticeParser.tryParsing(NOTICE_DEPENDENCY_PATTERN, line);
            if (!dependency.isPresent()) {
                dependency = NoticeParser.tryParsing(NOTICE_BUNDLES_DEPENDENCY_PATTERN, line);
            }
            dependency.ifPresent(declaredDependencies::add);
        }
        return Optional.of(new NoticeContents(noticeModuleName, declaredDependencies));
    }

    private static Optional<Dependency> tryParsing(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String groupId = matcher.group("groupId");
            String artifactId = matcher.group("artifactId");
            String version = matcher.group("version");
            String classifier = matcher.group("classifier");
            return Optional.of(Dependency.create(groupId, artifactId, version, classifier));
        }
        return Optional.empty();
    }
}

