/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tools.ci.utils.deploy;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.tools.ci.utils.shared.ParserUtils;

public class DeployParser {
    private static final Pattern DEPLOY_MODULE_PATTERN = Pattern.compile(".maven-deploy-plugin:.*:deploy .* @ (?<module>[^ _]+)(?:_[0-9.]+)? --.*");

    public static Set<String> parseDeployOutput(File buildResult) throws IOException {
        try (Stream<String> linesStream = Files.lines(buildResult.toPath());){
            Set<String> set = DeployParser.parseDeployOutput(linesStream);
            return set;
        }
    }

    static Set<String> parseDeployOutput(Stream<String> lines) {
        return ParserUtils.parsePluginOutput(lines, DEPLOY_MODULE_PATTERN, DeployParser::parseDeployBlock).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static boolean parseDeployBlock(Iterator<String> block) {
        return block.hasNext() && !block.next().contains("Skipping artifact deployment");
    }
}

