/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.types.RowType;
import org.apache.paimon.view.View;

public class ViewImpl
implements View {
    private final Identifier identifier;
    private final RowType rowType;
    private final String query;
    @Nullable
    private final String comment;
    private final Map<String, String> options;

    public ViewImpl(Identifier identifier, RowType rowType, String query, @Nullable String comment, Map<String, String> options) {
        this.identifier = identifier;
        this.rowType = rowType;
        this.query = query;
        this.comment = comment;
        this.options = options;
    }

    @Override
    public String name() {
        return this.identifier.getObjectName();
    }

    @Override
    public String fullName() {
        return this.identifier.getFullName();
    }

    @Override
    public RowType rowType() {
        return this.rowType;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public Optional<String> comment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public View copy(Map<String, String> dynamicOptions) {
        HashMap<String, String> newOptions = new HashMap<String, String>(this.options);
        newOptions.putAll(dynamicOptions);
        return new ViewImpl(this.identifier, this.rowType, this.query, this.comment, newOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewImpl view = (ViewImpl)o;
        return Objects.equals(this.identifier, view.identifier) && Objects.equals(this.rowType, view.rowType) && Objects.equals(this.query, view.query) && Objects.equals(this.comment, view.comment) && Objects.equals(this.options, view.options);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.rowType, this.query, this.comment, this.options);
    }
}

