/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ThreadUtils {
    public static String currentStackString() {
        StackTraceElement[] trace = Thread.getAllStackTraces().get(Thread.currentThread());
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement traceElement : trace) {
            builder.append("\nat ").append(traceElement);
        }
        return builder.toString();
    }

    public static void errorLogThreadDump(Logger logger) {
        ThreadInfo[] perThreadInfo = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        logger.error("Thread dump: \n{}", (Object)Arrays.stream(perThreadInfo).map(Object::toString).collect(Collectors.joining()));
    }

    public static boolean stackContains(String name) {
        StackTraceElement[] ss;
        for (StackTraceElement s : ss = new RuntimeException().getStackTrace()) {
            if (!s.toString().contains(name)) continue;
            return true;
        }
        return false;
    }

    public static ThreadFactory newDaemonThreadFactory(String prefix) {
        final ThreadFactory namedFactory = ThreadUtils.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    private static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = prefix + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(this.group, r, name);
            }
        };
    }
}

