/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.statistics.TruncateSimpleColStatsCollector;
import org.apache.paimon.table.SpecialFields;

public class StatsCollectorFactories {
    public static SimpleColStatsCollector.Factory[] createStatsFactories(CoreOptions options, List<String> fields) {
        return StatsCollectorFactories.createStatsFactories(options, fields, Collections.emptyList());
    }

    public static SimpleColStatsCollector.Factory[] createStatsFactories(CoreOptions options, List<String> fields, List<String> keyNames) {
        Options cfg = options.toConfiguration();
        SimpleColStatsCollector.Factory[] modes = new SimpleColStatsCollector.Factory[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            String fieldMode = cfg.get(ConfigOptions.key(String.format("%s.%s.%s", "fields", field, "stats-mode")).stringType().noDefaultValue());
            modes[i] = fieldMode != null ? SimpleColStatsCollector.from(fieldMode) : (SpecialFields.isSystemField(field) || keyNames.contains("_KEY_" + field) ? () -> new TruncateSimpleColStatsCollector(128) : SimpleColStatsCollector.from(cfg.get(CoreOptions.METADATA_STATS_MODE)));
        }
        return modes;
    }
}

