/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.responses;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.rest.RESTResponse;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class ErrorResponse
implements RESTResponse {
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_CODE = "code";
    private static final String FIELD_STACK = "stack";
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="code")
    private final Integer code;
    @JsonProperty(value="stack")
    private final List<String> stack;

    public ErrorResponse(String message, Integer code) {
        this.code = code;
        this.message = message;
        this.stack = new ArrayList<String>();
    }

    @JsonCreator
    public ErrorResponse(@JsonProperty(value="message") String message, @JsonProperty(value="code") int code, @JsonProperty(value="stack") List<String> stack) {
        this.message = message;
        this.code = code;
        this.stack = stack;
    }

    public ErrorResponse(String message, int code, Throwable throwable) {
        this.message = message;
        this.code = code;
        this.stack = this.getStackFromThrowable(throwable);
    }

    @JsonGetter(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonGetter(value="code")
    public Integer getCode() {
        return this.code;
    }

    @JsonGetter(value="stack")
    public List<String> getStack() {
        return this.stack;
    }

    private List<String> getStackFromThrowable(Throwable throwable) {
        if (throwable == null) {
            return new ArrayList<String>();
        }
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        return Arrays.asList(sw.toString().split("\n"));
    }
}

