/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.auth.BearTokenFileCredentialsProvider;
import org.apache.paimon.rest.auth.CredentialsProvider;
import org.apache.paimon.rest.auth.CredentialsProviderFactory;
import org.apache.paimon.rest.auth.CredentialsProviderType;

public class BearTokenFileCredentialsProviderFactory
implements CredentialsProviderFactory {
    @Override
    public String identifier() {
        return CredentialsProviderType.BEAR_TOKEN_FILE.name();
    }

    @Override
    public CredentialsProvider create(Options options) {
        if (!options.getOptional(RESTCatalogOptions.TOKEN_PROVIDER_PATH).isPresent()) {
            throw new IllegalArgumentException(RESTCatalogOptions.TOKEN_PROVIDER_PATH.key() + " is required");
        }
        String tokenFilePath = options.get(RESTCatalogOptions.TOKEN_PROVIDER_PATH);
        if (options.getOptional(RESTCatalogOptions.TOKEN_EXPIRATION_TIME).isPresent()) {
            long tokenExpireInMills = options.get(RESTCatalogOptions.TOKEN_EXPIRATION_TIME).toMillis();
            return new BearTokenFileCredentialsProvider(tokenFilePath, tokenExpireInMills);
        }
        return new BearTokenFileCredentialsProvider(tokenFilePath);
    }
}

