/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.partition.actions.AddDonePartitionAction;
import org.apache.paimon.partition.actions.MarkPartitionDoneEventAction;
import org.apache.paimon.partition.actions.SuccessFileMarkDoneAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;

public interface PartitionMarkDoneAction
extends Closeable {
    public void markDone(String var1) throws Exception;

    public static List<PartitionMarkDoneAction> createActions(FileStoreTable fileStoreTable, CoreOptions options) {
        return Arrays.stream(options.toConfiguration().get(CoreOptions.PARTITION_MARK_DONE_ACTION).split(",")).map(action -> {
            switch (action) {
                case "success-file": {
                    return new SuccessFileMarkDoneAction(fileStoreTable.fileIO(), fileStoreTable.location());
                }
                case "done-partition": {
                    return new AddDonePartitionAction(PartitionMarkDoneAction.createMetastoreClient(fileStoreTable, options));
                }
                case "mark-event": {
                    return new MarkPartitionDoneEventAction(PartitionMarkDoneAction.createMetastoreClient(fileStoreTable, options));
                }
            }
            throw new UnsupportedOperationException((String)action);
        }).collect(Collectors.toList());
    }

    public static MetastoreClient createMetastoreClient(FileStoreTable table, CoreOptions options) {
        MetastoreClient.Factory metastoreClientFactory = table.catalogEnvironment().metastoreClientFactory();
        if (options.toConfiguration().get(CoreOptions.PARTITION_MARK_DONE_ACTION).contains("done-partition")) {
            Preconditions.checkNotNull(metastoreClientFactory, "Cannot mark done partition for table without metastore.");
            Preconditions.checkArgument(options.partitionedTableInMetastore(), "Table should enable %s", CoreOptions.METASTORE_PARTITIONED_TABLE.key());
        }
        return metastoreClientFactory.create();
    }
}

