/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.metrics.CacheMetrics;
import org.apache.paimon.operation.metrics.ScanStats;

public class ScanMetrics {
    private static final int HISTOGRAM_WINDOW_SIZE = 100;
    public static final String GROUP_NAME = "scan";
    public static final String LAST_SCAN_DURATION = "lastScanDuration";
    public static final String SCAN_DURATION = "scanDuration";
    public static final String LAST_SCANNED_MANIFESTS = "lastScannedManifests";
    public static final String LAST_SCAN_SKIPPED_TABLE_FILES = "lastScanSkippedTableFiles";
    public static final String LAST_SCAN_RESULTED_TABLE_FILES = "lastScanResultedTableFiles";
    public static final String MANIFEST_HIT_CACHE = "manifestHitCache";
    public static final String MANIFEST_MISSED_CACHE = "manifestMissedCache";
    private final MetricGroup metricGroup;
    private final Histogram durationHistogram;
    private final CacheMetrics cacheMetrics;
    private ScanStats latestScan;

    public ScanMetrics(MetricRegistry registry, String tableName) {
        this.metricGroup = registry.tableMetricGroup(GROUP_NAME, tableName);
        this.metricGroup.gauge(LAST_SCAN_DURATION, () -> this.latestScan == null ? 0L : this.latestScan.getDuration());
        this.durationHistogram = this.metricGroup.histogram(SCAN_DURATION, 100);
        this.cacheMetrics = new CacheMetrics();
        this.metricGroup.gauge(LAST_SCANNED_MANIFESTS, () -> this.latestScan == null ? 0L : this.latestScan.getScannedManifests());
        this.metricGroup.gauge(LAST_SCAN_SKIPPED_TABLE_FILES, () -> this.latestScan == null ? 0L : this.latestScan.getSkippedTableFiles());
        this.metricGroup.gauge(LAST_SCAN_RESULTED_TABLE_FILES, () -> this.latestScan == null ? 0L : this.latestScan.getResultedTableFiles());
        this.metricGroup.gauge(MANIFEST_HIT_CACHE, () -> this.cacheMetrics.getHitObject().get());
        this.metricGroup.gauge(MANIFEST_MISSED_CACHE, () -> this.cacheMetrics.getMissedObject().get());
    }

    @VisibleForTesting
    MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public void reportScan(ScanStats scanStats) {
        this.latestScan = scanStats;
        this.durationHistogram.update(scanStats.getDuration());
    }

    public CacheMetrics getCacheMetrics() {
        return this.cacheMetrics;
    }
}

