/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.FileStorePathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagDeletion
extends FileDeletionBase<Snapshot> {
    private static final Logger LOG = LoggerFactory.getLogger(TagDeletion.class);

    public TagDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler, boolean cleanEmptyDirectories, int deleteFileThreadNum) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler, statsFileHandler, cleanEmptyDirectories, deleteFileThreadNum);
    }

    @Override
    public void cleanUnusedDataFiles(Snapshot taggedSnapshot, Predicate<ExpireFileEntry> skipper) {
        Collection<ExpireFileEntry> manifestEntries;
        try {
            manifestEntries = this.readMergedDataFiles(taggedSnapshot);
        }
        catch (IOException e) {
            LOG.info("Skip data file clean for the tag of id {}.", (Object)taggedSnapshot.id(), (Object)e);
            return;
        }
        HashSet<Path> dataFileToDelete = new HashSet<Path>();
        for (ExpireFileEntry entry : manifestEntries) {
            if (skipper.test(entry)) continue;
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            dataFileToDelete.add(new Path(bucketPath, entry.fileName()));
            for (String file : entry.extraFiles()) {
                dataFileToDelete.add(new Path(bucketPath, file));
            }
            this.recordDeletionBuckets(entry);
        }
        this.deleteFiles(dataFileToDelete, this.fileIO::deleteQuietly);
    }

    @Override
    public void cleanUnusedManifests(Snapshot taggedSnapshot, Set<String> skippingSet) {
        this.cleanUnusedManifests(taggedSnapshot, skippingSet, true, false);
    }

    public Predicate<ExpireFileEntry> dataFileSkipper(Snapshot fromSnapshot) throws Exception {
        return this.dataFileSkipper(Collections.singletonList(fromSnapshot));
    }

    public Predicate<ExpireFileEntry> dataFileSkipper(List<Snapshot> fromSnapshots) throws Exception {
        HashMap<BinaryRow, Map<Integer, Set<String>>> skipped = new HashMap<BinaryRow, Map<Integer, Set<String>>>();
        for (Snapshot snapshot : fromSnapshots) {
            this.addMergedDataFiles(skipped, snapshot);
        }
        return entry -> this.containsDataFile((Map<BinaryRow, Map<Integer, Set<String>>>)skipped, (ExpireFileEntry)entry);
    }
}

