/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestFileMetaSerializer;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class ManifestList
extends ObjectsFile<ManifestFileMeta> {
    private ManifestList(FileIO fileIO, ManifestFileMetaSerializer serializer, RowType schema, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, String compression, PathFactory pathFactory, @Nullable SegmentsCache<Path> cache) {
        super(fileIO, serializer, schema, readerFactory, writerFactory, compression, pathFactory, cache);
    }

    public List<ManifestFileMeta> readAllManifests(Snapshot snapshot) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(this.readDataManifests(snapshot));
        result.addAll(this.readChangelogManifests(snapshot));
        return result;
    }

    public List<ManifestFileMeta> readDataManifests(Snapshot snapshot) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(this.read(snapshot.baseManifestList()));
        result.addAll(this.readDeltaManifests(snapshot));
        return result;
    }

    public List<ManifestFileMeta> readDeltaManifests(Snapshot snapshot) {
        return this.read(snapshot.deltaManifestList());
    }

    public List<ManifestFileMeta> readChangelogManifests(Snapshot snapshot) {
        return snapshot.changelogManifestList() == null ? Collections.emptyList() : this.read(snapshot.changelogManifestList());
    }

    public String write(List<ManifestFileMeta> metas) {
        return super.writeWithoutRolling(metas);
    }

    public static class Factory {
        private final FileIO fileIO;
        private final FileFormat fileFormat;
        private final String compression;
        private final FileStorePathFactory pathFactory;
        @Nullable
        private final SegmentsCache<Path> cache;

        public Factory(FileIO fileIO, FileFormat fileFormat, String compression, FileStorePathFactory pathFactory, @Nullable SegmentsCache<Path> cache) {
            this.fileIO = fileIO;
            this.fileFormat = fileFormat;
            this.compression = compression;
            this.pathFactory = pathFactory;
            this.cache = cache;
        }

        public ManifestList create() {
            RowType metaType = VersionedObjectSerializer.versionType(ManifestFileMeta.SCHEMA);
            return new ManifestList(this.fileIO, new ManifestFileMetaSerializer(), metaType, this.fileFormat.createReaderFactory(metaType), this.fileFormat.createWriterFactory(metaType), this.compression, this.pathFactory.manifestListFactory(), this.cache);
        }
    }
}

