/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.statistics.NoneSimpleColStatsCollector;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public abstract class StatsCollectingSingleFileWriter<T, R>
extends SingleFileWriter<T, R> {
    @Nullable
    private final SimpleStatsExtractor simpleStatsExtractor;
    @Nullable
    private SimpleStatsCollector simpleStatsCollector = null;
    @Nullable
    private SimpleColStats[] noneStats = null;
    private final boolean isStatsDisabled;

    public StatsCollectingSingleFileWriter(FileIO fileIO, FormatWriterFactory factory2, Path path, Function<T, InternalRow> converter, RowType writeSchema, @Nullable SimpleStatsExtractor simpleStatsExtractor, String compression, SimpleColStatsCollector.Factory[] statsCollectors, boolean asyncWrite) {
        super(fileIO, factory2, path, converter, compression, asyncWrite);
        this.simpleStatsExtractor = simpleStatsExtractor;
        if (this.simpleStatsExtractor == null) {
            this.simpleStatsCollector = new SimpleStatsCollector(writeSchema, statsCollectors);
        }
        Preconditions.checkArgument(statsCollectors.length == writeSchema.getFieldCount(), "The stats collector is not aligned to write schema.");
        this.isStatsDisabled = Arrays.stream(SimpleColStatsCollector.create(statsCollectors)).allMatch(p -> p instanceof NoneSimpleColStatsCollector);
        if (this.isStatsDisabled) {
            this.noneStats = (SimpleColStats[])IntStream.range(0, statsCollectors.length).mapToObj(i -> SimpleColStats.NONE).toArray(SimpleColStats[]::new);
        }
    }

    @Override
    public void write(T record) throws IOException {
        InternalRow rowData = this.writeImpl(record);
        if (this.simpleStatsCollector != null && !this.simpleStatsCollector.isDisabled()) {
            this.simpleStatsCollector.collect(rowData);
        }
    }

    @Override
    public void writeBundle(BundleRecords bundle) throws IOException {
        Preconditions.checkState(this.simpleStatsExtractor != null, "Can't write bundle without simpleStatsExtractor, we may lose all the statistical information");
        super.writeBundle(bundle);
    }

    public SimpleColStats[] fieldStats() throws IOException {
        Preconditions.checkState(this.closed, "Cannot access metric unless the writer is closed.");
        if (this.simpleStatsExtractor != null) {
            if (this.isStatsDisabled) {
                return this.noneStats;
            }
            return this.simpleStatsExtractor.extract(this.fileIO, this.path);
        }
        return this.simpleStatsCollector.extract();
    }
}

