/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.KeyValueThinSerializer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.KeyValueDataFileWriter;
import org.apache.paimon.io.KeyValueDataFileWriterImpl;
import org.apache.paimon.io.KeyValueThinDataFileWriterImpl;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.StatsCollectorFactories;

public class KeyValueFileWriterFactory {
    private final FileIO fileIO;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final WriteFormatContext formatContext;
    private final long suggestedFileSize;
    private final CoreOptions options;
    private final FileIndexOptions fileIndexOptions;

    private KeyValueFileWriterFactory(FileIO fileIO, long schemaId, WriteFormatContext formatContext, long suggestedFileSize, CoreOptions options) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.keyType = formatContext.keyType;
        this.valueType = formatContext.valueType;
        this.formatContext = formatContext;
        this.suggestedFileSize = suggestedFileSize;
        this.options = options;
        this.fileIndexOptions = options.indexColumnsOptions();
    }

    public RowType keyType() {
        return this.keyType;
    }

    public RowType valueType() {
        return this.valueType;
    }

    @VisibleForTesting
    public DataFilePathFactory pathFactory(int level) {
        return this.formatContext.pathFactory(level);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingMergeTreeFileWriter(int level, FileSource fileSource) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.formatContext.pathFactory(level).newPath(), level, fileSource), this.suggestedFileSize);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingChangelogFileWriter(int level) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.formatContext.pathFactory(level).newChangelogPath(), level, FileSource.APPEND), this.suggestedFileSize);
    }

    private KeyValueDataFileWriter createDataFileWriter(Path path, int level, FileSource fileSource) {
        return this.formatContext.thinModeEnabled() ? new KeyValueThinDataFileWriterImpl(this.fileIO, this.formatContext.writerFactory(level), path, new KeyValueThinSerializer(this.keyType, this.valueType)::toRow, this.keyType, this.valueType, this.formatContext.extractor(level), this.schemaId, level, this.formatContext.compression(level), this.options, fileSource, this.fileIndexOptions) : new KeyValueDataFileWriterImpl(this.fileIO, this.formatContext.writerFactory(level), path, new KeyValueSerializer(this.keyType, this.valueType)::toRow, this.keyType, this.valueType, this.formatContext.extractor(level), this.schemaId, level, this.formatContext.compression(level), this.options, fileSource, this.fileIndexOptions);
    }

    public void deleteFile(DataFileMeta file) {
        this.fileIO.deleteQuietly(this.formatContext.pathFactory(file.level()).toPath(file));
    }

    public void copyFile(DataFileMeta sourceFile, DataFileMeta targetFile) throws IOException {
        Path sourcePath = this.formatContext.pathFactory(sourceFile.level()).toPath(sourceFile);
        Path targetPath = this.formatContext.pathFactory(targetFile.level()).toPath(targetFile);
        this.fileIO.copyFile(sourcePath, targetPath, true);
    }

    public FileIO getFileIO() {
        return this.fileIO;
    }

    public String newChangelogFileName(int level) {
        return this.formatContext.pathFactory(level).newChangelogFileName();
    }

    public static Builder builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, Map<String, FileStorePathFactory> format2PathFactory, long suggestedFileSize) {
        return new Builder(fileIO, schemaId, keyType, valueType, fileFormat, format2PathFactory, suggestedFileSize);
    }

    private static class WriteFormatContext {
        private final Function<Integer, String> level2Format;
        private final Function<Integer, String> level2Compress;
        private final Map<String, Optional<SimpleStatsExtractor>> format2Extractor;
        private final Map<String, DataFilePathFactory> format2PathFactory;
        private final Map<String, FormatWriterFactory> format2WriterFactory;
        private final RowType keyType;
        private final RowType valueType;
        private final boolean thinModeEnabled;

        private WriteFormatContext(BinaryRow partition, int bucket, RowType keyType, RowType valueType, FileFormat defaultFormat, Map<String, FileStorePathFactory> parentFactories, CoreOptions options) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.thinModeEnabled = options.dataFileThinMode() && this.supportsThinMode(keyType, valueType);
            RowType writeRowType = KeyValue.schema(this.thinModeEnabled ? RowType.of() : keyType, valueType);
            Map<Integer, String> fileFormatPerLevel = options.fileFormatPerLevel();
            this.level2Format = level -> fileFormatPerLevel.getOrDefault(level, defaultFormat.getFormatIdentifier());
            String defaultCompress = options.fileCompression();
            Map<Integer, String> fileCompressionPerLevel = options.fileCompressionPerLevel();
            this.level2Compress = level -> fileCompressionPerLevel.getOrDefault(level, defaultCompress);
            this.format2Extractor = new HashMap<String, Optional<SimpleStatsExtractor>>();
            this.format2PathFactory = new HashMap<String, DataFilePathFactory>();
            this.format2WriterFactory = new HashMap<String, FormatWriterFactory>();
            SimpleColStatsCollector.Factory[] statsCollectorFactories = StatsCollectorFactories.createStatsFactories(options, writeRowType.getFieldNames(), this.thinModeEnabled ? keyType.getFieldNames() : Collections.emptyList());
            for (String format : parentFactories.keySet()) {
                this.format2PathFactory.put(format, parentFactories.get(format).createDataFilePathFactory(partition, bucket));
                FileFormat fileFormat = FileFormat.fromIdentifier(format, options.toConfiguration());
                this.format2Extractor.put(format, format.equals("avro") ? Optional.empty() : fileFormat.createStatsExtractor(writeRowType, statsCollectorFactories));
                this.format2WriterFactory.put(format, fileFormat.createWriterFactory(writeRowType));
            }
        }

        private boolean supportsThinMode(RowType keyType, RowType valueType) {
            Set keyFieldIds = valueType.getFields().stream().map(DataField::id).collect(Collectors.toSet());
            for (DataField field : keyType.getFields()) {
                if (!SpecialFields.isKeyField(field.name())) {
                    return false;
                }
                if (keyFieldIds.contains(field.id() - 0x3FFFFFFF)) continue;
                return false;
            }
            return true;
        }

        private boolean thinModeEnabled() {
            return this.thinModeEnabled;
        }

        @Nullable
        private SimpleStatsExtractor extractor(int level) {
            return this.format2Extractor.get(this.level2Format.apply(level)).orElse(null);
        }

        private DataFilePathFactory pathFactory(int level) {
            return this.format2PathFactory.get(this.level2Format.apply(level));
        }

        private FormatWriterFactory writerFactory(int level) {
            return this.format2WriterFactory.get(this.level2Format.apply(level));
        }

        private String compression(int level) {
            return this.level2Compress.apply(level);
        }
    }

    public static class Builder {
        private final FileIO fileIO;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final Map<String, FileStorePathFactory> format2PathFactory;
        private final long suggestedFileSize;

        private Builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, Map<String, FileStorePathFactory> format2PathFactory, long suggestedFileSize) {
            this.fileIO = fileIO;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.format2PathFactory = format2PathFactory;
            this.suggestedFileSize = suggestedFileSize;
        }

        public KeyValueFileWriterFactory build(BinaryRow partition, int bucket, CoreOptions options) {
            WriteFormatContext context = new WriteFormatContext(partition, bucket, this.keyType, this.valueType, this.fileFormat, this.format2PathFactory, options);
            return new KeyValueFileWriterFactory(this.fileIO, this.schemaId, context, this.suggestedFileSize, options);
        }
    }
}

