/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.ColumnReader;
import org.apache.paimon.format.parquet.reader.ParquetDictionary;
import org.apache.paimon.format.parquet.reader.ParquetReadState;
import org.apache.paimon.format.parquet.reader.RunLengthDecoder;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesInput;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.Dictionary;
import org.apache.paimon.shade.org.apache.parquet.column.Encoding;
import org.apache.paimon.shade.org.apache.parquet.column.ValuesType;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV1;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV2;
import org.apache.paimon.shade.org.apache.parquet.column.page.DictionaryPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnReader<VECTOR extends WritableColumnVector>
implements ColumnReader<VECTOR> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractColumnReader.class);
    private final PageReader pageReader;
    protected final Dictionary dictionary;
    protected final int maxDefLevel;
    protected final ColumnDescriptor descriptor;
    private boolean isCurrentPageDictionaryEncoded;
    private final ParquetReadState readState;
    RunLengthDecoder runLenDecoder;
    ByteBufferInputStream dataInputStream;
    private RunLengthDecoder dictionaryIdsDecoder;

    public AbstractColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReadStore.getPageReader(descriptor);
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        this.readState = new ParquetReadState(pageReadStore.getRowIndexes().orElse(null));
        DictionaryPage dictionaryPage = this.pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        long totalValueCount = this.pageReader.getTotalValueCount();
        if (totalValueCount == 0L) {
            throw new IOException("totalValueCount == 0");
        }
    }

    protected void checkTypeName(PrimitiveType.PrimitiveTypeName expectedName) {
        PrimitiveType.PrimitiveTypeName actualName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
        Preconditions.checkArgument(actualName == expectedName, "Expected type name: %s, actual type name: %s", new Object[]{expectedName, actualName});
    }

    @Override
    public final void readToVector(int readNumber, VECTOR vector) throws IOException {
        int pageValueCount;
        int rowId = 0;
        WritableIntVector dictionaryIds = null;
        if (this.dictionary != null) {
            dictionaryIds = vector.reserveDictionaryIds(readNumber);
        }
        this.readState.resetForNewBatch(readNumber);
        while (!(this.readState.rowsToReadInBatch <= 0 || this.readState.valuesToReadInPage == 0 && (pageValueCount = this.readPage()) < 0 || this.readState.isFinished())) {
            long pageRowId = this.readState.rowId;
            int leftInBatch = this.readState.rowsToReadInBatch;
            int leftInPage = this.readState.valuesToReadInPage;
            int readBatch = Math.min(leftInBatch, leftInPage);
            long rangeStart = this.readState.currentRangeStart();
            long rangeEnd = this.readState.currentRangeEnd();
            if (pageRowId < rangeStart) {
                int toSkip = (int)(rangeStart - pageRowId);
                if (toSkip >= leftInPage) {
                    pageRowId += (long)leftInPage;
                    leftInPage = 0;
                } else if (this.isCurrentPageDictionaryEncoded) {
                    this.runLenDecoder.skipDictionaryIds(toSkip, this.maxDefLevel, this.dictionaryIdsDecoder);
                    pageRowId += (long)toSkip;
                    leftInPage -= toSkip;
                } else {
                    this.skipBatch(toSkip);
                    pageRowId += (long)toSkip;
                    leftInPage -= toSkip;
                }
            } else if (pageRowId > rangeEnd) {
                this.readState.nextRange();
            } else {
                long start = pageRowId;
                long end = Math.min(rangeEnd, pageRowId + (long)readBatch - 1L);
                int num = (int)(end - start + 1L);
                if (this.isCurrentPageDictionaryEncoded) {
                    this.runLenDecoder.readDictionaryIds(num, dictionaryIds, (WritableColumnVector)vector, rowId, this.maxDefLevel, this.dictionaryIdsDecoder);
                    if (vector.hasDictionary() || rowId == 0 && this.supportLazyDecode()) {
                        vector.setDictionary(new ParquetDictionary(this.dictionary));
                    } else {
                        this.readBatchFromDictionaryIds(rowId, num, vector, dictionaryIds);
                    }
                } else {
                    if (vector.hasDictionary() && rowId != 0) {
                        this.readBatchFromDictionaryIds(0, rowId, vector, vector.getDictionaryIds());
                    }
                    vector.setDictionary(null);
                    this.readBatch(rowId, num, vector);
                }
                leftInBatch -= num;
                pageRowId += (long)num;
                leftInPage -= num;
                rowId += num;
            }
            this.readState.rowsToReadInBatch = leftInBatch;
            this.readState.valuesToReadInPage = leftInPage;
            this.readState.rowId = pageRowId;
        }
    }

    private int readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return -1;
        }
        long pageFirstRowIndex = page.getFirstRowIndex().orElse(0L);
        int pageValueCount = page.accept(new DataPage.Visitor<Integer>(){

            @Override
            public Integer visit(DataPageV1 dataPageV1) {
                try {
                    return AbstractColumnReader.this.readPageV1(dataPageV1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Integer visit(DataPageV2 dataPageV2) {
                try {
                    return AbstractColumnReader.this.readPageV2(dataPageV2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.readState.resetForNewPage(pageValueCount, pageFirstRowIndex);
        return pageValueCount;
    }

    private int readPageV1(DataPageV1 page) throws IOException {
        int pageValueCount = page.getValueCount();
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + (Object)((Object)page.getDlEncoding()));
        }
        int bitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxDefinitionLevel());
        this.runLenDecoder = new RunLengthDecoder(bitWidth);
        try {
            BytesInput bytes = page.getBytes();
            ByteBufferInputStream in = bytes.toInputStream();
            rlReader.initFromPage(pageValueCount, in);
            this.runLenDecoder.initFromStream(pageValueCount, in);
            this.prepareNewPage(page.getValueEncoding(), in, pageValueCount);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private int readPageV2(DataPageV2 page) throws IOException {
        int pageValueCount = page.getValueCount();
        int bitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxDefinitionLevel());
        this.runLenDecoder = new RunLengthDecoder(bitWidth, false);
        this.runLenDecoder.initFromStream(pageValueCount, page.getDefinitionLevels().toInputStream());
        try {
            this.prepareNewPage(page.getDataEncoding(), page.getData().toInputStream(), pageValueCount);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private void prepareNewPage(Encoding dataEncoding, ByteBufferInputStream in, int pageValueCount) throws IOException {
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + (Object)((Object)dataEncoding));
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("Unsupported encoding: " + (Object)((Object)dataEncoding));
            }
            this.dataInputStream = null;
            this.dictionaryIdsDecoder = new RunLengthDecoder();
            try {
                this.dictionaryIdsDecoder.initFromStream(pageValueCount, in);
            }
            catch (IOException e) {
                throw new IOException("could not read dictionary in col " + this.descriptor, e);
            }
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + (Object)((Object)dataEncoding));
            }
            this.dictionaryIdsDecoder = null;
            LOG.debug("init from page at offset {} for length {}", (Object)in.position(), (Object)in.available());
            this.dataInputStream = in.remainingStream();
            this.isCurrentPageDictionaryEncoded = false;
        }
        this.afterReadPage();
    }

    final void skipDataBuffer(int length) {
        try {
            this.dataInputStream.skipFully(length);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to skip " + length + " bytes", e);
        }
    }

    final ByteBuffer readDataBuffer(int length) {
        try {
            return this.dataInputStream.slice(length).order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes", e);
        }
    }

    protected void afterReadPage() {
    }

    protected boolean supportLazyDecode() {
        return true;
    }

    protected abstract void readBatch(int var1, int var2, VECTOR var3);

    protected abstract void skipBatch(int var1);

    protected abstract void readBatchFromDictionaryIds(int var1, int var2, VECTOR var3, WritableIntVector var4);
}

