/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;

public class DeletionVectorsMaintainer {
    private final IndexFileHandler indexFileHandler;
    private final Map<String, DeletionVector> deletionVectors;
    private boolean modified;

    private DeletionVectorsMaintainer(IndexFileHandler fileHandler, Map<String, DeletionVector> deletionVectors) {
        this.indexFileHandler = fileHandler;
        this.deletionVectors = deletionVectors;
        this.modified = false;
    }

    public void notifyNewDeletion(String fileName, long position) {
        DeletionVector deletionVector = this.deletionVectors.computeIfAbsent(fileName, k -> new BitmapDeletionVector());
        if (deletionVector.checkedDelete(position)) {
            this.modified = true;
        }
    }

    public void notifyNewDeletion(String fileName, DeletionVector deletionVector) {
        this.deletionVectors.put(fileName, deletionVector);
        this.modified = true;
    }

    public void mergeNewDeletion(String fileName, DeletionVector deletionVector) {
        DeletionVector old = this.deletionVectors.get(fileName);
        if (old != null) {
            deletionVector.merge(old);
        }
        this.deletionVectors.put(fileName, deletionVector);
        this.modified = true;
    }

    public void removeDeletionVectorOf(String fileName) {
        if (this.deletionVectors.containsKey(fileName)) {
            this.deletionVectors.remove(fileName);
            this.modified = true;
        }
    }

    public List<IndexFileMeta> writeDeletionVectorsIndex() {
        if (this.modified) {
            this.modified = false;
            return this.indexFileHandler.writeDeletionVectorsIndex(this.deletionVectors);
        }
        return Collections.emptyList();
    }

    public Optional<DeletionVector> deletionVectorOf(String fileName) {
        return Optional.ofNullable(this.deletionVectors.get(fileName));
    }

    public IndexFileHandler indexFileHandler() {
        return this.indexFileHandler;
    }

    @VisibleForTesting
    public Map<String, DeletionVector> deletionVectors() {
        return this.deletionVectors;
    }

    public static Factory factory(IndexFileHandler handler) {
        return new Factory(handler);
    }

    public static class Factory {
        private final IndexFileHandler handler;

        public Factory(IndexFileHandler handler) {
            this.handler = handler;
        }

        public DeletionVectorsMaintainer createOrRestore(@Nullable Long snapshotId, BinaryRow partition, int bucket) {
            List<IndexFileMeta> indexFiles = snapshotId == null ? Collections.emptyList() : this.handler.scan(snapshotId, "DELETION_VECTORS", partition, bucket);
            HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>(this.handler.readAllDeletionVectors(indexFiles));
            return this.createOrRestore(deletionVectors);
        }

        @VisibleForTesting
        public DeletionVectorsMaintainer createOrRestore(@Nullable Long snapshotId, BinaryRow partition) {
            List<IndexFileMeta> indexFiles = snapshotId == null ? Collections.emptyList() : this.handler.scanEntries((long)snapshotId, "DELETION_VECTORS", partition).stream().map(IndexManifestEntry::indexFile).collect(Collectors.toList());
            HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>(this.handler.readAllDeletionVectors(indexFiles));
            return this.createOrRestore(deletionVectors);
        }

        public DeletionVectorsMaintainer create() {
            return this.createOrRestore(new HashMap<String, DeletionVector>());
        }

        public DeletionVectorsMaintainer createOrRestore(Map<String, DeletionVector> deletionVectors) {
            return new DeletionVectorsMaintainer(this.handler, deletionVectors);
        }
    }
}

