/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class IDMapping<T> {
    private final Function<T, T> copy;
    private final List<T> values = new ArrayList<T>();
    private final Map<T, Integer> indexMap = new HashMap<T, Integer>();
    private int nextIndex = 0;

    public IDMapping(Function<T, T> copy) {
        this.copy = copy;
    }

    public int index(T t) {
        Integer index = this.indexMap.get(t);
        if (index == null) {
            index = this.nextIndex;
            ++this.nextIndex;
            T copied = this.copy.apply(t);
            this.indexMap.put(copied, index);
            this.values.add(copied);
        }
        return index;
    }

    public T get(int index) {
        return this.values.get(index);
    }
}

